/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload.util.mime;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.fileupload.util.mime.QuotedPrintableDecoder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public final class QuotedPrintableDecoderTestCase {
    private static final String US_ASCII_CHARSET = "US-ASCII";

    private static void assertEncoded(String clearText, String encoded) throws Exception {
        byte[] expected = clearText.getBytes(US_ASCII_CHARSET);
        ByteArrayOutputStream out = new ByteArrayOutputStream(encoded.length());
        byte[] encodedData = encoded.getBytes(US_ASCII_CHARSET);
        QuotedPrintableDecoder.decode((byte[])encodedData, (OutputStream)out);
        byte[] actual = out.toByteArray();
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    private static void assertIOException(String messageText, String encoded) throws UnsupportedEncodingException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(encoded.length());
        byte[] encodedData = encoded.getBytes(US_ASCII_CHARSET);
        IOException e = (IOException)Assertions.assertThrows(IOException.class, () -> QuotedPrintableDecoder.decode((byte[])encodedData, (OutputStream)out));
        String em = e.getMessage();
        Assert.assertTrue((String)("Expected to find " + messageText + " in '" + em + "'"), (boolean)em.contains(messageText));
    }

    @Test
    public void basicEncodeDecode() throws Exception {
        QuotedPrintableDecoderTestCase.assertEncoded("= Hello there =\r\n", "=3D Hello there =3D=0D=0A");
    }

    @Test
    public void emptyDecode() throws Exception {
        QuotedPrintableDecoderTestCase.assertEncoded("", "");
    }

    @Test(expected=IOException.class)
    public void invalidCharDecode() throws Exception {
        QuotedPrintableDecoderTestCase.assertEncoded("=\r\n", "=3D=XD=XA");
    }

    @Test
    public void invalidQuotedPrintableEncoding() throws Exception {
        QuotedPrintableDecoderTestCase.assertIOException("truncated escape sequence", "YWJjMTIzXy0uKn4hQCMkJV4mKCkre31cIlxcOzpgLC9bXQ==");
    }

    @Test
    public void invalidSoftBreak1() throws Exception {
        QuotedPrintableDecoderTestCase.assertIOException("CR must be followed by LF", "=\r\r");
    }

    @Test
    public void invalidSoftBreak2() throws Exception {
        QuotedPrintableDecoderTestCase.assertIOException("CR must be followed by LF", "=\rn");
    }

    @Test
    public void plainDecode() throws Exception {
        QuotedPrintableDecoderTestCase.assertEncoded("The quick brown fox jumps over the lazy dog.", "The quick brown fox jumps over the lazy dog.");
    }

    @Test
    public void softLineBreakDecode() throws Exception {
        QuotedPrintableDecoderTestCase.assertEncoded("If you believe that truth=beauty, then surely mathematics is the most beautiful branch of philosophy.", "If you believe that truth=3Dbeauty, then surely=20=\r\nmathematics is the most beautiful branch of philosophy.");
    }

    @Test
    public void truncatedEscape() throws Exception {
        QuotedPrintableDecoderTestCase.assertIOException("truncated", "=1");
    }

    @Test
    public void unsafeDecode() throws Exception {
        QuotedPrintableDecoderTestCase.assertEncoded("=\r\n", "=3D=0D=0A");
    }

    @Test
    public void unsafeDecodeLowerCase() throws Exception {
        QuotedPrintableDecoderTestCase.assertEncoded("=\r\n", "=3d=0d=0a");
    }
}

