/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.datasources;

import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.InitialContext;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.apache.commons.dbcp2.datasources.SharedPoolDataSource;
import org.apache.commons.dbcp2.datasources.SharedPoolDataSourceFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

public class TestFactory {
    @ParameterizedTest
    @CsvSource(value={"dataSourceName,                 java:comp/env/jdbc/bookstoreCPDS", "description,                    This is a test.", "jndiEnvironment,                X", "loginTimeout,                   30000", "blockWhenExhausted,             false", "evictionPolicyClassName,        org.apache.commons.pool2.impl.DefaultEvictionPolicy", "lifo,                           true", "maxIdlePerKey,                  4", "maxTotalPerKey,                 4", "maxWaitMillis,                  30001", "minEvictableIdleTimeMillis,     30002", "minIdlePerKey,                  4", "numTestsPerEvictionRun,         2", "softMinEvictableIdleTimeMillis, 30003", "testOnCreate,                   true", "testOnBorrow,                   true", "testOnReturn,                   true", "testWhileIdle,                  true", "timeBetweenEvictionRunsMillis,  30004", "validationQuery,                select 1", "validationQueryTimeout,         30005", "rollbackAfterValidation,        false", "maxConnLifetimeMillis,          60000", "defaultAutoCommit,              true", "defaultTransactionIsolation,    X", "defaultReadOnly,                true"})
    void testJNDI2Pools(String string, String value) throws Exception {
        Reference refObj = new Reference(SharedPoolDataSource.class.getName());
        refObj.add(new StringRefAddr(string, value));
        InitialContext context = new InitialContext();
        Hashtable env = new Hashtable();
        SharedPoolDataSourceFactory factory = new SharedPoolDataSourceFactory();
        CompositeName name = new CompositeName("myDB");
        Object obj = factory.getObjectInstance(refObj, name, context, env);
        Assertions.assertNotNull((Object)obj);
        CompositeName name2 = new CompositeName("myDB2");
        Object obj2 = factory.getObjectInstance(refObj, name2, context, env);
        Assertions.assertNotNull((Object)obj2);
    }
}

