/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import java.time.ZoneOffset;
import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.Converter;
import org.apache.commons.beanutils2.converters.ZoneOffsetConverter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ZoneOffsetConverterTest {
    private Converter<ZoneOffset> converter;

    protected Class<?> getExpectedType() {
        return ZoneOffset.class;
    }

    protected Converter<ZoneOffset> makeConverter() {
        return new ZoneOffsetConverter();
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.converter = this.makeConverter();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.converter = null;
    }

    @Test
    public void testSimpleConversion() throws Exception {
        int i;
        String[] message = new String[]{"from String", "from String", "from String", "from String", "from String", "from String", "from String", "from String"};
        Object[] input = new Object[]{"-12:00", "+14:00", "+02:00"};
        ZoneOffset[] expected = new ZoneOffset[]{ZoneOffset.of("-12:00"), ZoneOffset.of("+14:00"), ZoneOffset.of("+02:00")};
        for (i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)expected[i], (Object)this.converter.convert(ZoneOffset.class, input[i]), (String)(message[i] + " to URI"));
            Assertions.assertEquals((Object)expected[i], (Object)this.converter.convert(null, input[i]), (String)(message[i] + " to null type"));
        }
        for (i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)input[i], (Object)this.converter.convert(String.class, (Object)expected[i]), (String)(input[i] + " to String"));
        }
    }

    @Test
    public void testUnsupportedType() {
        Assertions.assertThrows(ConversionException.class, () -> this.converter.convert(ConversionException.class, (Object)"http://www.apache.org"));
    }
}

