/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.util;

import java.net.InetAddress;
import java.net.UnknownHostException;

public final class IpChecker {
    private static int[] masks = new int[]{0, 128, 192, 224, 240, 248, 252, 254};

    private IpChecker() {
    }

    public static boolean matches(String pExpected, String pToCheck) {
        boolean ipv6;
        boolean bl = ipv6 = pToCheck.startsWith("[") && pToCheck.endsWith("]") || pToCheck.contains(":");
        if (ipv6 || pExpected.contains(":")) {
            return pExpected.contains(":") && IpChecker.matchesIPv6(pExpected, pToCheck);
        }
        String[] parts = pExpected.split("/", 2);
        if (parts.length == 1) {
            IpChecker.convertToIntTuple(pExpected);
            IpChecker.convertToIntTuple(pToCheck);
            return pExpected.equals(pToCheck);
        }
        if (parts.length == 2) {
            int[] ipToCheck = IpChecker.convertToIntTuple(pToCheck);
            int[] ipPattern = IpChecker.convertToIntTuple(parts[0]);
            int[] netmask = parts[1].length() <= 2 ? IpChecker.transformCidrToNetmask(parts[1]) : IpChecker.convertToIntTuple(parts[1]);
            for (int i = 0; i < ipToCheck.length; ++i) {
                if ((ipPattern[i] & netmask[i]) == (ipToCheck[i] & netmask[i])) continue;
                return false;
            }
            return true;
        }
        throw new IllegalArgumentException("Invalid IP adress specification " + pExpected);
    }

    public static boolean matchesIPv6(String pExpected, String pToCheck) {
        String[] parts = pExpected.split("/", 2);
        if (parts.length == 1) {
            try {
                InetAddress expected = InetAddress.getByName(pExpected);
                InetAddress checked = InetAddress.getByName(pToCheck);
                return expected.equals(checked);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Invalid IP adress specification " + pExpected);
            }
        }
        int prefix = Integer.parseInt(parts[1]);
        if (prefix < 0 || prefix > 128) {
            throw new IllegalArgumentException("Invalid IP adress specification " + pExpected);
        }
        try {
            InetAddress expected = InetAddress.getByName(parts[0]);
            InetAddress checked = InetAddress.getByName(pToCheck);
            byte[] e = expected.getAddress();
            byte[] c = checked.getAddress();
            int div = prefix / 8;
            for (int i = 0; i < div; ++i) {
                if (e[i] == c[i]) continue;
                return false;
            }
            int rem = prefix % 8;
            if (rem != 0) {
                return (e[div] & masks[rem]) == (c[div] & masks[rem]);
            }
            return true;
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid IP adress specification " + pExpected);
        }
    }

    private static int[] transformCidrToNetmask(String pCidrString) {
        try {
            int pCidr = Integer.parseInt(pCidrString);
            if (pCidr < 0 || pCidr > 32) {
                throw new IllegalArgumentException("Invalid netmask specification " + pCidr);
            }
            StringBuilder buf = new StringBuilder();
            buf.append("1".repeat(pCidr));
            buf.append("0".repeat(32 - pCidr));
            int[] ret = new int[4];
            int start = 0;
            int end = 8;
            for (int j = 0; j < 4; ++j) {
                ret[j] = Integer.parseInt(buf.substring(start, end), 2);
                start += 8;
                end += 8;
            }
            return ret;
        }
        catch (NumberFormatException exp) {
            throw new IllegalArgumentException("Invalid netmask specification " + pCidrString, exp);
        }
    }

    private static int[] convertToIntTuple(String pAddress) {
        String[] parts = pAddress.split("\\.");
        if (parts.length != 4) {
            throw new IllegalArgumentException("Invalid IP-Adresse " + pAddress);
        }
        int[] ret = new int[4];
        for (int i = 0; i < 4; ++i) {
            try {
                ret[i] = Integer.parseInt(parts[i]);
                if (ret[i] >= 0 && ret[i] <= 255) continue;
                throw new IllegalArgumentException("Invalid IP-Adresse " + pAddress);
            }
            catch (NumberFormatException exp) {
                throw new IllegalArgumentException("Invalid IP-Adresse " + pAddress, exp);
            }
        }
        return ret;
    }
}

