/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.cloud;

import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.cloud.ServiceDiscovery;
import org.apache.camel.cloud.ServiceDiscoveryFactory;
import org.apache.camel.impl.cloud.CachingServiceDiscovery;
import org.apache.camel.util.ObjectHelper;

public class CachingServiceDiscoveryFactory
implements ServiceDiscoveryFactory {
    private Integer timeout;
    private TimeUnit units;
    private ServiceDiscovery serviceDiscovery;

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public TimeUnit getUnits() {
        return this.units;
    }

    public void setUnits(TimeUnit units) {
        this.units = units;
    }

    public ServiceDiscovery getServiceDiscovery() {
        return this.serviceDiscovery;
    }

    public void setServiceDiscovery(ServiceDiscovery serviceDiscovery) {
        this.serviceDiscovery = serviceDiscovery;
    }

    @Override
    public ServiceDiscovery newInstance(CamelContext camelContext) throws Exception {
        ObjectHelper.notNull(this.serviceDiscovery, "ServiceDiscovery configuration");
        ObjectHelper.notNull(this.timeout, "CachingServiceDiscovery timeout");
        ObjectHelper.notNull(this.units, "CachingServiceDiscovery time units");
        return new CachingServiceDiscovery(this.serviceDiscovery, this.units.toMillis(this.timeout.intValue()));
    }
}

