/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: XmlObject2DOMXDA.java,v $
  Version:       $Name:  $ $Revision: 1.7 $
  Last Modified: $Date: 2005/05/19 10:07:02 $
 *****************************************************************************/
package org.ten60.netkernel.xml.transrepresentation;

import com.ten60.netkernel.urii.IURRepresentation;
import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.util.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.representation.*;
import org.apache.xmlbeans.*;
import org.w3c.dom.*;
import com.ten60.netkernel.util.NetKernelException;
/**
 * Converts a XmlObject to a DOM
 * @author  pjr
 */
public class XmlObject2DOMXDA extends NKFTransreptorImpl
{
	public boolean supports(IURRepresentation aFrom, Class aTo)
	{	return ( aFrom.hasAspect(IAspectXmlObject.class) && ( aTo.isAssignableFrom(IXAspect.class) || aTo.isAssignableFrom(IAspectDOM.class) || aTo.isAssignableFrom(IAspectXDA.class) ) );
	}
	
	protected void transrepresent(INKFConvenienceHelper context) throws Exception
	{	IURRepresentation from=context.getThisRequest().getArgumentValue(INKFRequestReadOnly.URI_SYSTEM);
		IAspectXmlObject xoa=(IAspectXmlObject)from.getAspect(IAspectXmlObject.class);
		IAspectSAX sa=(IAspectSAX)context.transrept(xoa, IAspectSAX.class);
		IXAspect xa=(IXAspect)context.transrept(sa, IXAspect.class);
		DOMXDAAspect dxa=new DOMXDAAspect(new DOMXDA(xa.getReadOnlyDocument(), false));
		/*  Need to go direct to DOM throught newDOMNode() API - but this is producing a horrible fragment!!!*/
		INKFResponse resp=context.createResponseFrom(from);
		resp.addAspect(dxa);
		context.setResponse(resp);
	}
	
}