/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: BinaryStreamSAXAspect.java,v $
  Version:       $Name:  $ $Revision: 1.6 $
  Last Modified: $Date: 2004/10/12 13:44:07 $
 *****************************************************************************/
package org.ten60.netkernel.xml.representation;

import org.ten60.netkernel.layer1.representation.MonoRepresentationImpl;
import com.ten60.netkernel.urii.aspect.*;
import com.ten60.netkernel.urii.*;

import org.xml.sax.*;
import org.xml.sax.ext.*;
import org.xml.sax.helpers.*;
import java.io.*;
import java.util.List;
/**
 *
 * @author  tab
 */
public class BinaryStreamSAXAspect implements IAspectSAX
{
	IAspectBinaryStream mReadableStream;
	
	/** Creates a new instance of SAXProxy */
	public BinaryStreamSAXAspect(IAspectBinaryStream aReadableStream)
	{	mReadableStream = aReadableStream;
	}
	
	public InputSource getInputSource() throws IOException
	{	InputSource result;
		if (mReadableStream instanceof IAspectReadableBinaryStream)
		{	result = new InputSource(((IAspectReadableBinaryStream)mReadableStream).getInputStream());
		}
		else
		{	PipedOutputStream os = new PipedOutputStream();
			Thread t = new ReaderThread(mReadableStream, os);
			result = new InputSource(new PipedInputStream(os));
			t.start();
		}
		return result;
	}
	
	private class ReaderThread extends Thread
	{	private IAspectBinaryStream mProxy;
		private OutputStream mStream;
		public ReaderThread(IAspectBinaryStream aProxy, OutputStream aStream)
		{	mProxy = aProxy;
			mStream = aStream;
		}
		public void run()
		{	try
			{	mProxy.write(mStream);
				mStream.flush();
			}
			catch (IOException e)
			{	// nothing we can do
			}
			finally
			{	try
				{	mStream.close();
				} catch (IOException e2) {;}
			}
		}
	}
	
	public void handleContent(XMLReader aReader, List aUsageDependencies) throws IOException, SAXException
	{	if(aReader instanceof XMLFilter)
		{	XMLFilter f=(XMLFilter)aReader;
			if(f.getParent()==null)
			{	f.setParent(XMLReaderFactory.createXMLReader());
			}
		}
		aReader.parse(getInputSource());
	}
	
	/* @deprecated
	 */
	public static IURRepresentation create(IURMeta aMeta, IAspectBinaryStream aProxy)
	{	return new MonoRepresentationImpl(aMeta, new BinaryStreamSAXAspect(aProxy));
	}	
}