/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: ServletParameterNVPAspect.java,v $
 * Version:       $Name:  $ $Revision: 1.1 $
 * Last Modified: $Date: 2005/08/15 13:48:26 $
 *****************************************************************************/
package org.ten60.transport.servlet;

import javax.servlet.http.*;
import com.ten60.netkernel.urii.*;

import org.ten60.netkernel.layer1.representation.*;
import java.util.*;

/**
 * NVP wrapper aspect around a servlet parameters
 * @author  tab
 */
public class ServletParameterNVPAspect implements IAspectNVP, IURAspect
{
	private Map mParameters;
	
	/** Creates a new instance of ParameterNVPProxy */
	private ServletParameterNVPAspect(HttpServletRequest aRequest)
	{	mParameters = aRequest.getParameterMap();
	}
	
	public java.util.Set getNames()
	{	return mParameters.keySet();
	}
	
	public String getValue(String name)
	{	String result=null;
		String[] results=(String[])mParameters.get(name);
		if (results!=null && results.length>0)
		{	result = results[0];
		}
		return result;
	}
	
	public java.util.List getValues(String name)
	{	
		String[] results=(String[])mParameters.get(name);
		ArrayList result = new ArrayList(results.length);
		for (int i=0; i<results.length; i++)
		{	result.add(results[i]);
		}
		return result;
	}
	
	public static IURRepresentation create(IURMeta aMeta, HttpServletRequest aRequest)
	{	return new MonoRepresentationImpl(aMeta, new ServletParameterNVPAspect(aRequest));
	}
	
}