/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: HTTPRedirectAccessor.java,v $
 * Version:       $Name:  $ $Revision: 1.5 $
 * Last Modified: $Date: 2004/08/31 15:17:35 $
 *****************************************************************************/
package org.ten60.transport.http.request.accessor;

import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.transport.http.response.representation.*;
import org.ten60.netkernel.layer1.representation.*;
import com.ten60.netkernel.util.PairList;
import com.ten60.netkernel.urii.*;
import java.util.Collections;

/**
 * Creates a multipart response with a dummy main part and a 
 * HTTP Response Code part which defines a redirect to the
 * uri given by the operator.
 * @author  pjr
 */
public class HTTPRedirectAccessor extends XAccessor
{
	/** Creates a new instance of HTTPRedirectAccessor */
	public HTTPRedirectAccessor()
	{	declareArgument(OPERATOR, true, true);
		declareThreadSafe();
	}
	
	protected com.ten60.netkernel.urii.IURRepresentation source(XAHelper aHelper) throws Exception
	{	String uri=aHelper.getOperator().getXDA().getText("./text()", true);
		PairList headers = new PairList(1);
		headers.put("Location",uri);
		ResponseCodeAspect rca = new ResponseCodeAspect(303,null,headers);
		MonoRepresentationImpl rcr = new MonoRepresentationImpl(aHelper.getDependencyMeta("",1), rca);
		// return an multipart with the primary part being an empty string and the only extra part being the
		// responseCodeAspect 
		IURAspect aspect = new ByteArrayAspect(new byte[0]);
		IURRepresentation primary = new MonoRepresentationImpl(aHelper.getDependencyMeta("",1),aspect);
		return MultiPartAspect.create(primary, Collections.singletonMap("redirect",rcr));
	}	
}