/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.util;

import com.ten60.netkernel.util.FastXPath;
import com.ten60.netkernel.util.SysLogger;
import com.ten60.netkernel.util.XMLUtils;
import java.util.Collections;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;

public final class XMLReadable {
    private Node mContextNode;

    public XMLReadable(Node aContextNode) {
        this.mContextNode = aContextNode;
    }

    public List getNodes(String aXPath) {
        try {
            return FastXPath.eval(this.mContextNode, aXPath);
        }
        catch (TransformerException e) {
            SysLogger.log(2, this, aXPath + " eval failed on config");
            return Collections.EMPTY_LIST;
        }
    }

    public List getTexts(String aXPath, boolean aTrim) {
        try {
            List nodes = FastXPath.eval(this.mContextNode, aXPath);
            for (int i = 0; i < nodes.size(); ++i) {
                Node n = (Node)nodes.get(i);
                String text = XMLUtils.getText(n);
                if (aTrim) {
                    text = text.trim();
                }
                nodes.set(i, text);
            }
            return nodes;
        }
        catch (TransformerException e) {
            SysLogger.log(2, this, aXPath + " eval failed on config");
            return Collections.EMPTY_LIST;
        }
    }

    public String getText(String aXPath) {
        String result = "";
        try {
            Node n = FastXPath.getSingleNode(this.mContextNode, aXPath);
            if (n != null) {
                result = XMLUtils.getText(n);
            }
        }
        catch (TransformerException e) {
            SysLogger.log(2, this, aXPath + " eval failed on config");
        }
        return result;
    }

    public int getInt(String aXPath, int aDefault) {
        try {
            Node n = FastXPath.getSingleNode(this.mContextNode, aXPath);
            String s = XMLUtils.getText(n);
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            SysLogger.log(2, this, aXPath + " eval failed on config");
            return aDefault;
        }
    }
}

