/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class CheapMap
implements Map {
    private List mList;

    public CheapMap(int aInitialSize) {
        this.mList = new ArrayList(aInitialSize);
    }

    public void clear() {
        this.mList.clear();
    }

    public boolean containsKey(Object key) {
        boolean result = false;
        Iterator i = this.mList.iterator();
        while (i.hasNext()) {
            Entry e = (Entry)i.next();
            if (!e.getKey().equals(key)) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean containsValue(Object value) {
        boolean result = false;
        Iterator i = this.mList.iterator();
        while (i.hasNext()) {
            Entry e = (Entry)i.next();
            if (!e.getValue().equals(value)) continue;
            result = true;
            break;
        }
        return result;
    }

    public Set entrySet() {
        throw new IllegalArgumentException("not supported");
    }

    public Object get(Object key) {
        Object result = null;
        for (int i = this.mList.size() - 1; i >= 0; --i) {
            Entry e = (Entry)this.mList.get(i);
            if (!e.getKey().equals(key)) continue;
            result = e.getValue();
            break;
        }
        return result;
    }

    public boolean isEmpty() {
        return this.mList.size() == 0;
    }

    public Set keySet() {
        HashSet c = new HashSet(this.mList.size());
        Iterator i = this.mList.iterator();
        while (i.hasNext()) {
            Map.Entry e = (Map.Entry)i.next();
            c.add(e.getKey());
        }
        return c;
    }

    public Object put(Object key, Object value) {
        Entry e = new Entry(key, value);
        this.mList.add(e);
        return null;
    }

    public void putAll(Map t) {
        throw new IllegalArgumentException("not supported");
    }

    public Object remove(Object key) {
        Object result = null;
        for (int i = 0; i < this.mList.size(); ++i) {
            Entry e = (Entry)this.mList.get(i);
            if (!e.getKey().equals(key)) continue;
            result = e.getValue();
            this.mList.remove(i);
            break;
        }
        return result;
    }

    public int size() {
        return this.mList.size();
    }

    public Collection values() {
        ArrayList c = new ArrayList(this.mList.size());
        Iterator i = this.mList.iterator();
        while (i.hasNext()) {
            Map.Entry e = (Map.Entry)i.next();
            c.add(e.getValue());
        }
        return c;
    }

    private static final class Entry
    implements Map.Entry {
        private Object mKey;
        private Object mValue;

        public Entry(Object aKey, Object aValue) {
            this.mKey = aKey;
            this.mValue = aValue;
        }

        public Object getKey() {
            return this.mKey;
        }

        public Object getValue() {
            return this.mValue;
        }

        public Object setValue(Object aValue) {
            Object result = this.mValue;
            this.mValue = aValue;
            return this.mValue;
        }
    }
}

