/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.urii.accessor;

import com.ten60.netkernel.container.Container;
import com.ten60.netkernel.module.ModuleDefinition;
import com.ten60.netkernel.scheduler.Scheduler;
import com.ten60.netkernel.urii.IURAccessor;
import com.ten60.netkernel.urii.IURAccessorMeta;
import com.ten60.netkernel.urii.IURRepresentation;
import com.ten60.netkernel.urii.URIdentifier;
import com.ten60.netkernel.urii.aspect.NetKernelExceptionAspect;
import com.ten60.netkernel.urii.representation.SimpleRepresentationImpl;
import com.ten60.netkernel.urrequest.URRequest;
import com.ten60.netkernel.urrequest.URResult;
import com.ten60.netkernel.util.NetKernelException;

public abstract class AccessorImpl
extends SimpleRepresentationImpl
implements IURAccessor {
    private URIdentifier mURI;
    private Scheduler mScheduler;
    private ModuleDefinition mModule;
    private Container mContainer;
    static /* synthetic */ Class class$com$ten60$netkernel$urii$aspect$IAspectNetKernelException;

    public AccessorImpl(IURAccessorMeta aMeta) {
        super(aMeta);
    }

    public void init(URIdentifier aURI, ModuleDefinition aModule, Container aContainer) {
        this.mURI = aURI;
        this.mModule = aModule;
        this.mContainer = aContainer;
        this.mScheduler = (Scheduler)aContainer.getComponent(Scheduler.URI);
    }

    public IURAccessorMeta getAccessorMeta() {
        return (IURAccessorMeta)this.getMeta();
    }

    public URIdentifier getURI() {
        return this.mURI;
    }

    protected ModuleDefinition getModule() {
        return this.mModule;
    }

    protected Container getContainer() {
        return this.mContainer;
    }

    public void receiveAsyncResult(URResult aResult) {
    }

    public void receiveAsyncException(URResult aResult) {
        URRequest originalRequest = aResult.getRequest().getParent();
        NetKernelException originalException = ((NetKernelExceptionAspect)aResult.getResource().getAspect(class$com$ten60$netkernel$urii$aspect$IAspectNetKernelException == null ? (class$com$ten60$netkernel$urii$aspect$IAspectNetKernelException = AccessorImpl.class$("com.ten60.netkernel.urii.aspect.IAspectNetKernelException")) : class$com$ten60$netkernel$urii$aspect$IAspectNetKernelException)).getException();
        NetKernelException e = new NetKernelException("Received exception", "in accessor [" + this.getClass().getName() + "]", originalRequest.getURI().toString());
        e.addCause(originalException);
        URResult result = new URResult(originalRequest, NetKernelExceptionAspect.create(e));
        this.mScheduler.receiveAsyncException(result);
    }

    protected void issueResult(URRequest aRequest, IURRepresentation aResource, boolean aException) {
        URResult result = new URResult(aRequest, aResource);
        if (aException) {
            this.mScheduler.receiveAsyncException(result);
        } else {
            this.mScheduler.receiveAsyncResult(result);
        }
    }

    protected void issueRequest(URRequest aRequest) {
        aRequest.setRequestor(this);
        this.mScheduler.requestAsync(aRequest);
    }

    protected URResult issueSynchRequest(URRequest aRequest) throws NetKernelException, InterruptedException {
        return this.mScheduler.requestSynch(aRequest);
    }

    protected IURRepresentation transrepresent(IURRepresentation aFrom, URIdentifier aFromURI, Class aToClass, URRequest aOriginalRequest) throws NetKernelException {
        URRequest request = new URRequest(aFromURI, this, aOriginalRequest.getSession(), this.mModule, 32, null, aOriginalRequest, aToClass);
        request.addArg(URRequest.URI_SYSTEM, aFrom);
        URResult result = this.mScheduler.requestSynch(request);
        return result.getResource();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

