/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.scheduler.debug;

import com.ten60.netkernel.scheduler.RequestState;
import com.ten60.netkernel.scheduler.Scheduler;
import com.ten60.netkernel.scheduler.debug.BreakpointedState;
import com.ten60.netkernel.scheduler.debug.IBreakpoint;
import com.ten60.netkernel.urrequest.URRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Debugger {
    private final List mBreakpoints = new ArrayList();
    private final List mBreakpointedStates = Collections.synchronizedList(new ArrayList());
    private Scheduler mScheduler;

    public Debugger(Scheduler aScheduler) {
        this.mScheduler = aScheduler;
    }

    public void addBreakpoint(IBreakpoint aBreakpoint) {
        this.mBreakpoints.add(aBreakpoint);
    }

    public void removeBreakpoint(IBreakpoint aBreakpoint) {
        this.mBreakpoints.remove(aBreakpoint);
    }

    public List getBreakpoints() {
        return this.mBreakpoints;
    }

    public boolean catchBreakpoint(RequestState aState) {
        boolean result = false;
        if (!this.mBreakpoints.isEmpty()) {
            IBreakpoint found = null;
            boolean negative = false;
            Iterator i = this.mBreakpoints.iterator();
            while (i.hasNext()) {
                IBreakpoint bp = (IBreakpoint)i.next();
                if (!bp.matches(aState, this)) continue;
                if (bp.isPositive()) {
                    if (found != null) continue;
                    found = bp;
                    continue;
                }
                negative = true;
                break;
            }
            if (found != null && !negative) {
                if (aState.getState() == 11) {
                    aState.setState(12);
                } else {
                    aState.setState(1);
                }
                BreakpointedState bps = new BreakpointedState(aState, found);
                this.mBreakpointedStates.add(bps);
                result = true;
            }
        }
        return result;
    }

    public List getBreakpointedStates() {
        return this.mBreakpointedStates;
    }

    public void release(BreakpointedState aState) {
        if (this.mBreakpointedStates.remove(aState)) {
            this.mScheduler.releaseBreakpointedState(aState.getState());
        }
    }

    public void releaseAll() {
        Iterator i = this.mBreakpointedStates.iterator();
        while (i.hasNext()) {
            BreakpointedState bps = (BreakpointedState)i.next();
            i.remove();
            this.mScheduler.releaseBreakpointedState(bps.getState());
        }
    }

    public URRequest getRootOf(RequestState aState) {
        RequestState state;
        URRequest request = aState.getOriginalRequest();
        while (request.getParent() != null) {
            request = request.getParent();
        }
        if (request != aState.getOriginalRequest() && (state = this.mScheduler.getPendingStateFor(request)) != null) {
            request = state.getOriginalRequest();
        }
        return request;
    }

    public RequestState getStateFor(URRequest aRequest) {
        return this.mScheduler.getPendingStateFor(aRequest);
    }
}

