/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.scheduler;

import com.ten60.netkernel.scheduler.WorkerThread;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class WorkerThreadPool {
    private ThreadGroup mThreadGroup;
    protected final ArrayList mProcessorThreads = new ArrayList();
    private final ArrayList mDyingThreads = new ArrayList();
    private boolean mStarted;
    private boolean mStopped;

    public WorkerThreadPool(String aName, int aInitialThreads) {
        this.mThreadGroup = new ThreadGroup(aName);
        this.setCount(aInitialThreads);
    }

    public ThreadGroup getThreadGroup() {
        return this.mThreadGroup;
    }

    public void setCount(int aThreadCount) {
        block3: {
            int actualCount;
            block2: {
                actualCount = this.threadCount();
                if (actualCount >= aThreadCount) break block2;
                int threadsToCreate = aThreadCount - actualCount;
                for (int i = 0; i < threadsToCreate; ++i) {
                    WorkerThread pt = this.createNewThread(this.mThreadGroup);
                    this.mProcessorThreads.add(pt);
                    if (!this.mStarted || this.mStopped) continue;
                    pt.start();
                }
                break block3;
            }
            if (actualCount <= aThreadCount) break block3;
            int threadsToStop = actualCount - aThreadCount;
            Iterator iterator = this.mProcessorThreads.iterator();
            for (int i = 0; i < threadsToStop; ++i) {
                WorkerThread pt = (WorkerThread)iterator.next();
                pt.requestStop();
                iterator.remove();
                this.mDyingThreads.add(pt);
            }
        }
    }

    public int threadCount() {
        this.purgeDyingThreads();
        return this.mProcessorThreads.size();
    }

    private void purgeDyingThreads() {
        Iterator i = this.mDyingThreads.iterator();
        while (i.hasNext()) {
            WorkerThread pt = (WorkerThread)i.next();
            if (pt.isAlive()) continue;
            i.remove();
        }
    }

    protected WorkerThread createNewThread(ThreadGroup aThisGroup) {
        return new WorkerThread(this, aThisGroup);
    }

    public void start() {
        if (!this.mStarted && !this.mStopped) {
            this.mStarted = true;
            Iterator i = this.mProcessorThreads.iterator();
            while (i.hasNext()) {
                WorkerThread pt = (WorkerThread)i.next();
                pt.start();
            }
        }
    }

    public void stop() {
        if (this.mStarted && !this.mStopped) {
            this.setCount(0);
            this.mStopped = true;
        }
    }

    public void join() throws InterruptedException {
        if (this.mStopped) {
            Iterator i = this.mDyingThreads.iterator();
            while (i.hasNext()) {
                WorkerThread pt = (WorkerThread)i.next();
                pt.join();
            }
            this.mDyingThreads.clear();
        }
    }

    public void replace(Thread aThread) {
        if (this.mProcessorThreads.remove(aThread)) {
            ((WorkerThread)aThread).requestStop();
            this.mDyingThreads.add(aThread);
            WorkerThread pt = this.createNewThread(this.mThreadGroup);
            this.mProcessorThreads.add(pt);
            if (this.mStarted && !this.mStopped) {
                pt.start();
            }
        }
    }

    public abstract void process() throws InterruptedException;
}

