/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.scheduler;

import com.ten60.netkernel.urrequest.IURRequestor;
import com.ten60.netkernel.urrequest.URRequest;
import com.ten60.netkernel.urrequest.URResult;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;

class SynchronousRequestor
implements IURRequestor {
    private Map mRequestToResultMap = Collections.synchronizedMap(new IdentityHashMap());

    SynchronousRequestor() {
    }

    public void receiveAsyncException(URResult aResult) {
        this.innerReceiveResult(aResult, true);
    }

    public void receiveAsyncResult(URResult aResult) {
        this.innerReceiveResult(aResult, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerReceiveResult(URResult aResult, boolean aException) {
        ResultStruct struct = new ResultStruct(aResult, aException);
        URRequest request = aResult.getRequest();
        this.mRequestToResultMap.put(request, struct);
        URRequest uRRequest = request;
        synchronized (uRRequest) {
            request.notify();
        }
    }

    public ResultStruct get(URRequest aRequest) {
        return (ResultStruct)this.mRequestToResultMap.remove(aRequest);
    }

    static class ResultStruct {
        public URResult result;
        boolean isException;

        public ResultStruct(URResult aResult, boolean aIsException) {
            this.result = aResult;
            this.isException = aIsException;
        }
    }
}

