/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.scheduler;

import com.ten60.netkernel.scheduler.RequestState;
import com.ten60.netkernel.urii.IURAccessor;
import com.ten60.netkernel.urii.URIdentifier;
import com.ten60.netkernel.urii.representation.ITransrepresentor;
import com.ten60.netkernel.util.XMLUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RequestStatistics {
    private Map mAccessorStats = new HashMap(128);
    private Map mTransreptorStats = new HashMap(64);
    private Map mFragmentorStats = new HashMap(64);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatisticsFor(RequestState aState, boolean aFailed) {
        URIdentifier key;
        IURAccessor accessor = aState.getAccessor();
        if (accessor != null && (key = accessor.getURI()) != null) {
            Stat stat;
            Object object = this.mAccessorStats;
            synchronized (object) {
                stat = (Stat)this.mAccessorStats.get(key);
                if (stat == null) {
                    stat = new Stat();
                    this.mAccessorStats.put(key, stat);
                }
            }
            object = stat;
            synchronized (object) {
                ++stat.mCount;
                if (aFailed) {
                    ++stat.mFailures;
                }
                stat.mElapsedTime += aState.getCummulativeTime();
                stat.mLocalTime += aState.getRequestTime();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatisticsFor(Object aTransreptor, long aElapsed, long aLocal, boolean aFailed) {
        Stat stat;
        Map map = aTransreptor instanceof ITransrepresentor ? this.mTransreptorStats : this.mFragmentorStats;
        String key = aTransreptor.getClass().getName();
        Object object = map;
        synchronized (object) {
            stat = (Stat)map.get(key);
            if (stat == null) {
                stat = new Stat();
                map.put(key, stat);
            }
        }
        object = stat;
        synchronized (object) {
            ++stat.mCount;
            if (aFailed) {
                ++stat.mFailures;
            }
            stat.mElapsedTime += aElapsed;
            stat.mLocalTime += aLocal;
        }
    }

    public long write(Writer aWriter) throws IOException {
        long totalTime = RequestStatistics.writeMap(aWriter, this.mAccessorStats, "ura");
        totalTime += RequestStatistics.writeMap(aWriter, this.mTransreptorStats, "transreptor");
        return totalTime += RequestStatistics.writeMap(aWriter, this.mFragmentorStats, "fragmentor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long writeMap(Writer aWriter, Map aMap, String aName) throws IOException {
        long totalTime = 0L;
        aWriter.write("<");
        aWriter.write(aName);
        aWriter.write("s>");
        Map map = aMap;
        synchronized (map) {
            Iterator i = aMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                Object key = entry.getKey();
                Stat stat = (Stat)entry.getValue();
                RequestStatistics.write(stat, key, aName, aWriter);
                totalTime += stat.mLocalTime;
            }
        }
        aWriter.write("</");
        aWriter.write(aName);
        aWriter.write("s>");
        return totalTime;
    }

    private static void write(Stat aStat, Object aKey, String aName, Writer aWriter) throws IOException {
        aWriter.write(60);
        aWriter.write(aName);
        aWriter.write(62);
        XMLUtils.write(aWriter, "key", XMLUtils.escape(aKey.toString()));
        XMLUtils.write(aWriter, "count", Integer.toString(aStat.mCount));
        XMLUtils.write(aWriter, "failures", Integer.toString(aStat.mFailures));
        XMLUtils.write(aWriter, "elapsed", Long.toString(aStat.mElapsedTime));
        XMLUtils.write(aWriter, "local", Long.toString(aStat.mLocalTime));
        aWriter.write("</");
        aWriter.write(aName);
        aWriter.write(62);
    }

    private static class Stat {
        public int mCount;
        public int mFailures;
        public long mElapsedTime;
        public long mLocalTime;

        private Stat() {
        }
    }
}

