/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.scheduler;

import com.ten60.netkernel.urii.IURAccessor;
import com.ten60.netkernel.urii.IURRepresentation;
import com.ten60.netkernel.urii.aspect.NetKernelExceptionAspect;
import com.ten60.netkernel.urrequest.URRequest;
import com.ten60.netkernel.util.NetKernelError;
import com.ten60.netkernel.util.NetKernelException;

public final class RequestState {
    public static final int STATE_MAP_REQUEST = 0;
    public static final int STATE_BREAKPOINT_BEFORE = 1;
    public static final int STATE_TEST_CACHE = 2;
    public static final int STATE_PENDING_OTHERS_RESULT = 3;
    public static final int STATE_PENDING_ACCESSOR = 4;
    public static final int STATE_REQUEST_REPRESENTATION = 5;
    public static final int STATE_PENDING_REPRESENTATION = 6;
    public static final int STATE_BUSY_ACCESSOR = 7;
    public static final int STATE_RELEASED_ACCESSOR = 8;
    public static final int STATE_FRAGMENTATION = 9;
    public static final int STATE_TRANSREPRESENTATION = 10;
    public static final int STATE_RESULT_READY = 11;
    public static final int STATE_BREAKPOINT_AFTER = 12;
    public static final int STATE_RETURN_RESULT = 13;
    public static final int STATE_COMPLETE = 14;
    private URRequest mOriginalRequest;
    private URRequest mMappedRequest;
    private URRequest mAccessorRequest;
    private IURAccessor mAccessor;
    private IURRepresentation mUncastResult;
    private IURRepresentation mResult;
    private int mState;
    private long mTotal;
    private long mLastStart;
    private long mFirstStart;
    private long mLastStop;
    private boolean mException;
    private String mFragment;
    private boolean mNeedsCaching;

    public RequestState(URRequest aOriginalRequest) {
        this.mFragment = aOriginalRequest.getURI().getFragment();
        this.mOriginalRequest = aOriginalRequest;
        this.mMappedRequest = aOriginalRequest;
        if (aOriginalRequest.getType() == 32) {
            this.mState = 10;
            this.mUncastResult = aOriginalRequest.getArg(URRequest.URI_SYSTEM);
        } else if (aOriginalRequest.getType() == 64) {
            this.mState = 9;
            this.mUncastResult = aOriginalRequest.getArg(URRequest.URI_SYSTEM);
        } else {
            this.mState = 0;
        }
        this.mLastStart = 0L;
    }

    public boolean resultNeedsCaching() {
        return this.mNeedsCaching;
    }

    public void setResultNeedsCaching() {
        this.mNeedsCaching = true;
    }

    public URRequest getMappedRequest() {
        return this.mMappedRequest;
    }

    public URRequest getOriginalRequest() {
        return this.mOriginalRequest;
    }

    public int getState() {
        return this.mState;
    }

    public void setMappedRequest(URRequest aRequest) {
        this.mMappedRequest = aRequest;
    }

    public void setState(int aState) {
        this.mState = aState;
    }

    public void setException(Throwable aThrowable) {
        if (aThrowable instanceof Exception) {
            NetKernelException e = new NetKernelException("Exception during request processing", "whilst " + RequestState.typeToString(this.getState()), this.getOriginalRequest().toString());
            e.addCause(aThrowable);
            this.mResult = NetKernelExceptionAspect.create(e);
        } else {
            NetKernelError e = new NetKernelError("Error during request processing", "whilst " + RequestState.typeToString(this.getState()), this.getOriginalRequest().toString());
            e.addCause(aThrowable);
            this.mResult = NetKernelExceptionAspect.create(e);
        }
        this.mException = true;
        this.setState(11);
    }

    public void setAccessorRequest(URRequest aRequest) {
        this.mAccessorRequest = aRequest;
    }

    public URRequest getAccessorRequest() {
        return this.mAccessorRequest;
    }

    public void setAccessor(IURAccessor aAccessor) {
        this.mAccessor = aAccessor;
    }

    public IURAccessor getAccessor() {
        return this.mAccessor;
    }

    public void setUncastResult(IURRepresentation aResult) {
        this.mUncastResult = aResult;
    }

    public IURRepresentation getUncastResult() {
        return this.mUncastResult;
    }

    public void setResult(IURRepresentation aResult) {
        this.mException = false;
        this.mResult = aResult;
    }

    public IURRepresentation getResult() {
        return this.mResult;
    }

    public boolean wasException() {
        return this.mException;
    }

    public String getFragment() {
        return this.mFragment;
    }

    public void pauseTimer() {
        if (this.mLastStart != 0L) {
            long now = System.currentTimeMillis();
            this.mTotal += now - this.mLastStart;
            this.mLastStart = 0L;
            this.mLastStop = now;
        }
    }

    public void resumeTimer() {
        this.mLastStart = System.currentTimeMillis();
        if (this.mFirstStart == 0L) {
            this.mFirstStart = this.mLastStart;
        }
    }

    public long getCummulativeTime() {
        return this.mLastStop - this.mFirstStart;
    }

    public long getRequestTime() {
        if (this.mLastStart != 0L) {
            this.pauseTimer();
        }
        return this.mTotal;
    }

    public static String typeToString(int aType) {
        String result;
        switch (aType) {
            case 0: {
                result = "mapping request";
                break;
            }
            case 2: {
                result = "looking for cached result";
                break;
            }
            case 3: {
                result = "pending result from another";
                break;
            }
            case 4: {
                result = "requesting accessor";
                break;
            }
            case 5: {
                result = "requesting result from accessor";
                break;
            }
            case 6: {
                result = "waiting for result...";
                break;
            }
            case 7: {
                result = "waiting for busy accessor...";
                break;
            }
            case 8: {
                result = "accessor released";
                break;
            }
            case 9: {
                result = "fragmenting result";
                break;
            }
            case 10: {
                result = "transrepresenting result";
                break;
            }
            case 11: {
                result = "result ready";
                break;
            }
            case 13: {
                result = "returning result";
                break;
            }
            case 14: {
                result = "complete";
                break;
            }
            case 1: {
                result = "breakpoint before";
                break;
            }
            case 12: {
                result = "breakpoint after";
                break;
            }
            default: {
                result = "??";
            }
        }
        return result;
    }
}

