/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.scheduler;

import com.ten60.netkernel.scheduler.RequestState;
import com.ten60.netkernel.scheduler.RequestTable;
import com.ten60.netkernel.urrequest.IRequestorSession;
import com.ten60.netkernel.urrequest.URRequest;
import com.ten60.netkernel.util.NetKernelError;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class PendingRequestMap {
    private final Map mMap = new IdentityHashMap();
    private final List mPendingResults = new ArrayList(16);

    public synchronized void put(URRequest aRequest, RequestState aState) {
        this.mMap.put(aRequest, aState);
    }

    public synchronized RequestState remove(URRequest aRequest) {
        return (RequestState)this.mMap.remove(aRequest);
    }

    public synchronized RequestState get(URRequest aRequest) {
        return (RequestState)this.mMap.get(aRequest);
    }

    public synchronized int size() {
        return this.mMap.size();
    }

    public synchronized boolean hasEquivalentInProgress(RequestState aState) {
        URRequest request = aState.getMappedRequest();
        Iterator i = this.mMap.keySet().iterator();
        while (i.hasNext()) {
            URRequest request2 = (URRequest)i.next();
            if (!request2.equals(request)) continue;
            aState.setState(3);
            this.mPendingResults.add(aState);
            return true;
        }
        return false;
    }

    public synchronized void notifyOfAvailableResult(RequestState aState, RequestTable aTable) {
        URRequest request = aState.getMappedRequest();
        Iterator i = this.mPendingResults.iterator();
        while (i.hasNext()) {
            RequestState state = (RequestState)i.next();
            if (!state.getMappedRequest().equals(request)) continue;
            i.remove();
            state.setState(2);
            aTable.put(state);
        }
    }

    public synchronized RequestState getNewestStateForSession(IRequestorSession aSession) {
        RequestState result = null;
        long newestTime = 0L;
        Iterator i = this.mMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            URRequest req = (URRequest)entry.getKey();
            if (!req.getSession().equals(aSession) || req.getTime() <= newestTime) continue;
            newestTime = req.getTime();
            result = (RequestState)entry.getValue();
        }
        return result;
    }

    public synchronized RequestState getOldestStateForSession(IRequestorSession aSession) {
        RequestState result = null;
        Iterator i = this.mMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            URRequest req = (URRequest)entry.getKey();
            if (!req.getSession().equals(aSession) || req.getParent() != null) continue;
            result = (RequestState)entry.getValue();
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean kill(IRequestorSession aSession, Map aStateToThreadMap, RequestTable aTable, boolean aOrphan, String aErrorId) {
        boolean result = false;
        RequestState state = this.getNewestStateForSession(aSession);
        if (state != null) {
            NetKernelError deathError = new NetKernelError(aErrorId, "process with pid [" + aSession.getId() + "] has been terminated", null);
            Map map = aStateToThreadMap;
            synchronized (map) {
                Thread t = (Thread)aStateToThreadMap.get(state);
                if (t != null) {
                    result = true;
                    t.stop(deathError);
                }
            }
            if (!result && aOrphan) {
                RequestState rs = (RequestState)this.mMap.remove(state.getMappedRequest());
                state.setException(deathError);
                aTable.put(state);
                result = true;
            }
        }
        return result;
    }
}

