/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.module.accessor;

import com.ten60.netkernel.module.accessor.ModuleResourceAccessorMeta;
import com.ten60.netkernel.module.accessor.ModuleResourceRepresentation;
import com.ten60.netkernel.urii.IURAccessorMeta;
import com.ten60.netkernel.urii.IURRepresentation;
import com.ten60.netkernel.urii.URIdentifier;
import com.ten60.netkernel.urii.accessor.AccessorImpl;
import com.ten60.netkernel.urii.aspect.BooleanAspect;
import com.ten60.netkernel.urii.aspect.IAspectBinaryStream;
import com.ten60.netkernel.urii.aspect.NetKernelExceptionAspect;
import com.ten60.netkernel.urii.aspect.VoidAspect;
import com.ten60.netkernel.urii.meta.MetaImpl;
import com.ten60.netkernel.urii.representation.MonoRepresentationImpl;
import com.ten60.netkernel.urrequest.IRequestorContext;
import com.ten60.netkernel.urrequest.URRequest;
import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.util.PairList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.regex.Matcher;

public class ModuleResourceAccessor
extends AccessorImpl {
    private static IURAccessorMeta sMeta = new ModuleResourceAccessorMeta();
    private PairList mExpiries;
    private static long sDefaultResourceExpiry = 0L;
    private static final long STATIC_OFFSET = 86400000L;
    static /* synthetic */ Class class$com$ten60$netkernel$urii$aspect$IAspectBinaryStream;

    public ModuleResourceAccessor() {
        super(sMeta);
    }

    public void requestAsync(URRequest aRequest) {
        switch (aRequest.getType()) {
            case 1: {
                this.source(aRequest);
                break;
            }
            case 2: {
                this.sink(aRequest);
                break;
            }
            case 4: {
                this.exists(aRequest);
                break;
            }
            case 8: {
                this.delete(aRequest);
            }
        }
    }

    public static void setDefaultResourceExpiry(long aPeriod) {
        sDefaultResourceExpiry = aPeriod;
    }

    public void setResourceExpiries(PairList aResourceExpiries) {
        this.mExpiries = aResourceExpiries;
    }

    private void source(URRequest aRequest) {
        try {
            String path = URI.create(aRequest.getURI().toString()).getSchemeSpecificPart();
            long expiryOffset = this.getModule().isExpanded() ? this.getExpiryOffset(aRequest) : 86400000L;
            ModuleResourceRepresentation representation = new ModuleResourceRepresentation(path, this.getModule(), this.getContainer(), expiryOffset);
            this.issueResult(aRequest, representation, false);
        }
        catch (IOException e) {
            String resourceName = aRequest.getURI().toString();
            IURRepresentation representation = NetKernelExceptionAspect.create(new NetKernelException("Error sourcing resource", "resource " + resourceName + " not found in module " + this.getModule().getURI().toString(), resourceName));
            this.issueResult(aRequest, representation, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sink(URRequest aRequest) {
        try {
            boolean auth = false;
            URRequest parent = aRequest.getParent();
            if (parent != null) {
                if (parent.getContext() == this.getModule()) {
                    auth = true;
                } else {
                    Iterator i = parent.getSuperStack().iterator();
                    while (i.hasNext()) {
                        IRequestorContext md = (IRequestorContext)i.next();
                        if (md != this.getModule()) continue;
                        auth = true;
                        break;
                    }
                }
            }
            if (!auth) {
                throw new Exception("External sink denied");
            }
            IURRepresentation representation = aRequest.getArg(URRequest.URI_SYSTEM);
            IAspectBinaryStream data = representation.hasAspect(class$com$ten60$netkernel$urii$aspect$IAspectBinaryStream == null ? (class$com$ten60$netkernel$urii$aspect$IAspectBinaryStream = ModuleResourceAccessor.class$("com.ten60.netkernel.urii.aspect.IAspectBinaryStream")) : class$com$ten60$netkernel$urii$aspect$IAspectBinaryStream) ? (IAspectBinaryStream)representation.getAspect(class$com$ten60$netkernel$urii$aspect$IAspectBinaryStream == null ? (class$com$ten60$netkernel$urii$aspect$IAspectBinaryStream = ModuleResourceAccessor.class$("com.ten60.netkernel.urii.aspect.IAspectBinaryStream")) : class$com$ten60$netkernel$urii$aspect$IAspectBinaryStream) : (IAspectBinaryStream)this.transrepresent(representation, URIdentifier.getUnique("literal:sink"), class$com$ten60$netkernel$urii$aspect$IAspectBinaryStream == null ? (class$com$ten60$netkernel$urii$aspect$IAspectBinaryStream = ModuleResourceAccessor.class$("com.ten60.netkernel.urii.aspect.IAspectBinaryStream")) : class$com$ten60$netkernel$urii$aspect$IAspectBinaryStream, aRequest).getAspect(class$com$ten60$netkernel$urii$aspect$IAspectBinaryStream == null ? (class$com$ten60$netkernel$urii$aspect$IAspectBinaryStream = ModuleResourceAccessor.class$("com.ten60.netkernel.urii.aspect.IAspectBinaryStream")) : class$com$ten60$netkernel$urii$aspect$IAspectBinaryStream);
            String path = URI.create(aRequest.getURI().toString()).getSchemeSpecificPart();
            File f = new File(this.getModule().getScratchDir(), path);
            f.getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(f);
            try {
                data.write(fos);
                fos.flush();
            }
            finally {
                fos.close();
            }
            this.issueResult(aRequest, VoidAspect.create(), false);
        }
        catch (Exception e) {
            NetKernelException e2 = new NetKernelException("Error sinking resource", null, aRequest.getURI().toString());
            e2.addCause(e);
            IURRepresentation representation = NetKernelExceptionAspect.create(e2);
            this.issueResult(aRequest, representation, true);
        }
    }

    private void exists(URRequest aRequest) {
        String path = URI.create(aRequest.getURI().toString()).getSchemeSpecificPart();
        URL url = this.getModule().getResource(path);
        MetaImpl meta = new MetaImpl("application/vnd.netkernel-boolean", 0L, 2);
        BooleanAspect aspect = new BooleanAspect(url != null);
        MonoRepresentationImpl rep = new MonoRepresentationImpl(meta, aspect);
        this.issueResult(aRequest, rep, false);
    }

    private void delete(URRequest aRequest) {
        String path = URI.create(aRequest.getURI().toString()).getSchemeSpecificPart();
        URL url = this.getModule().getResource(path);
        boolean deleted = false;
        if (url != null && url.getProtocol().equals("file") && url.toString().startsWith(this.getModule().getScratchDirURI())) {
            try {
                File f = new File(new URI(url.toString()));
                deleted = f.delete();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        MetaImpl meta = new MetaImpl("application/vnd.netkernel-boolean", 0L, 2);
        BooleanAspect aspect = new BooleanAspect(url != null);
        MonoRepresentationImpl rep = new MonoRepresentationImpl(meta, aspect);
        this.issueResult(aRequest, rep, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getExpiryOffset(URRequest aRequest) {
        long result = sDefaultResourceExpiry;
        String uriString = aRequest.getURI().toString();
        int size = this.mExpiries.size();
        for (int i = 0; i < size; ++i) {
            boolean matches;
            Matcher m;
            Matcher matcher = m = (Matcher)this.mExpiries.getValue1(i);
            synchronized (matcher) {
                m.reset(uriString);
                matches = m.matches();
            }
            if (!matches) continue;
            result = (Long)this.mExpiries.getValue2(i);
            break;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

