/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.module;

import com.ten60.netkernel.cache.Cache;
import com.ten60.netkernel.container.ComponentImpl;
import com.ten60.netkernel.container.Config;
import com.ten60.netkernel.container.Container;
import com.ten60.netkernel.module.MappedRequest;
import com.ten60.netkernel.module.MappingCache;
import com.ten60.netkernel.module.MappingDebug;
import com.ten60.netkernel.module.ModuleDefinition;
import com.ten60.netkernel.module.ModuleFactory;
import com.ten60.netkernel.module.URIMapping;
import com.ten60.netkernel.module.accessor.ModuleResourceAccessor;
import com.ten60.netkernel.module.rewrite.RegexRewriterRule;
import com.ten60.netkernel.urii.IURRepresentation;
import com.ten60.netkernel.urii.URIdentifier;
import com.ten60.netkernel.urii.accessor.AccessorFactory;
import com.ten60.netkernel.urii.fragment.IFragmentor;
import com.ten60.netkernel.urii.representation.ITransrepresentor;
import com.ten60.netkernel.urrequest.URRequest;
import com.ten60.netkernel.util.MultiMap;
import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.util.PairList;
import com.ten60.netkernel.util.SysLogger;
import com.ten60.netkernel.util.Utils;
import com.ten60.netkernel.util.Version;
import com.ten60.netkernel.util.XMLReadable;
import com.ten60.netkernel.util.XMLUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class ModuleManager
extends ComponentImpl {
    public static final String MODULE_SCHEME = "ffcpl";
    public static final String XAR_SUFFIX = ".xar";
    public static final String JAR_SUFFIX = ".jar";
    public static final URIdentifier URI = new URIdentifier("netkernel:module");
    private MultiMap mModules = new MultiMap(64, 2);
    private Container mContainer;
    private File mExpandedJarDir;
    private ModuleDefinition mDefaultCacheModule;
    private MappingCache mMappingCache;
    private static ModuleFactory mModuleFactory = new ModuleFactory();
    static /* synthetic */ Class class$com$ten60$netkernel$module$accessor$ModuleResourceAccessor;

    public ModuleManager() {
        super(URI, true);
    }

    public static void resetModuleFactory() {
        mModuleFactory.complete();
        mModuleFactory = new ModuleFactory();
    }

    public void start(Container aContainer) throws NetKernelException {
        this.mContainer = aContainer;
        this.reparseModules(aContainer);
        XMLReadable config = ((Config)aContainer.getComponent(Config.URI)).getReadable();
        int requestMappingCacheSize = config.getInt("system/requestMappingCacheSize", 512);
        this.mMappingCache = new MappingCache(requestMappingCacheSize);
        URIdentifier uri = new URIdentifier(config.getText("system/defaultCacheModule").trim());
        List versions = this.mModules.get(uri);
        if (versions.size() > 0) {
            this.mDefaultCacheModule = (ModuleDefinition)versions.get(0);
            ((Cache)this.mContainer.getComponent(Cache.URI)).registerDefaultCacheletModule(this.mDefaultCacheModule);
        } else {
            this.mDefaultCacheModule = null;
        }
    }

    public ModuleDefinition getDefaultCacheModule() {
        return this.mDefaultCacheModule;
    }

    public URL getDeployedModulesURL(Container aContainer) throws MalformedURLException {
        Config c = (Config)aContainer.getComponent(Config.URI);
        URI basePath = java.net.URI.create(aContainer.getBasePathURI());
        URI deployedModulesURI = java.net.URI.create(c.getReadable().getText("system/deployedModules"));
        deployedModulesURI = basePath.resolve(deployedModulesURI);
        return deployedModulesURI.toURL();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void reparseModules(Container aContainer) throws NetKernelException {
        Config c = (Config)aContainer.getComponent(Config.URI);
        long defaultResourceExpiry = c.getReadable().getInt("system/defaultResourceExpiry", 0);
        ModuleResourceAccessor.setDefaultResourceExpiry(defaultResourceExpiry);
        try {
            ModuleDefinition md;
            URL deployedModulesURL = this.getDeployedModulesURL(aContainer);
            InputStream is = deployedModulesURL.openStream();
            XMLReadable deployedModules = new XMLReadable(XMLUtils.parse(is));
            List modules = deployedModules.getTexts("/modules/module", true);
            URI basePath = java.net.URI.create(aContainer.getBasePathURI());
            NetKernelException exception = null;
            this.mModules.clear();
            Iterator i = modules.iterator();
            while (i.hasNext()) {
                try {
                    File m;
                    URI moduleURI = java.net.URI.create((String)i.next());
                    if (basePath != null) {
                        moduleURI = basePath.resolve(moduleURI);
                    }
                    if ((m = new File(moduleURI)).getName().endsWith(XAR_SUFFIX) || m.getName().endsWith(JAR_SUFFIX)) {
                        this.registerModule(m, true);
                        continue;
                    }
                    this.registerModule(m, false);
                }
                catch (Throwable t) {
                    if (exception == null) {
                        exception = new NetKernelException("Problems with Module Loading");
                    }
                    exception.addCause(t);
                }
            }
            mModuleFactory.complete();
            i = this.mModules.valueIterator();
            while (i.hasNext()) {
                md = (ModuleDefinition)i.next();
                try {
                    md.parseMappings(this, aContainer);
                }
                catch (Throwable t) {
                    if (exception == null) {
                        exception = new NetKernelException("Problems with Module Linking");
                    }
                    exception.addCause(t);
                }
            }
            i = this.mModules.valueIterator();
            while (i.hasNext()) {
                md = (ModuleDefinition)i.next();
                try {
                    md.parseFinal(this.mContainer);
                }
                catch (Throwable t) {
                    if (exception == null) {
                        exception = new NetKernelException("Problems with Module Linking");
                    }
                    exception.addCause(t);
                }
            }
            if (exception == null) return;
        }
        catch (Exception e) {
            NetKernelException nke = new NetKernelException("problems starting ModuleManager");
            nke.addCause(e);
            throw nke;
        }
    }

    private void registerModule(File aModule, boolean aIsZipped) throws NetKernelException {
        String moduleURIString = aModule.toURI().toString();
        if (File.separatorChar == '\\' && !moduleURIString.startsWith("file:///")) {
            moduleURIString = "file:///" + moduleURIString.substring(6);
        }
        if (aIsZipped) {
            moduleURIString = "jar:" + moduleURIString + "!/";
        }
        try {
            ModuleDefinition md = mModuleFactory.getModuleFor(moduleURIString, this);
            URIdentifier uri = md.getURI();
            this.mModules.put(uri, md);
        }
        catch (Throwable t) {
            NetKernelException e2 = new NetKernelException("Failed to Load Module", null, aModule.getAbsolutePath());
            e2.addCause(t);
            SysLogger.log2(3, this, "Failed to Load Module at [%1] : %2", aModule.getAbsolutePath(), e2.toString());
            throw e2;
        }
    }

    public ModuleDefinition getModule(URIdentifier aURI, Version aMin, Version aMax) throws NetKernelException {
        ModuleDefinition result = null;
        ModuleDefinition wrongVersion = null;
        List modules = this.mModules.get(aURI);
        Iterator i = modules.iterator();
        while (i.hasNext()) {
            ModuleDefinition md = (ModuleDefinition)i.next();
            if (aMin != null && md.getVersion().isLessThan(aMin)) {
                wrongVersion = md;
                continue;
            }
            if (aMax != null && md.getVersion().isGreaterThan(aMax)) {
                wrongVersion = md;
                continue;
            }
            if (result != null && !result.getVersion().isLessThan(md.getVersion())) continue;
            result = md;
        }
        if (result == null) {
            String message = wrongVersion != null ? "imported module of correct version not found" : "imported module not found ";
            throw new NetKernelException(message, message, aURI.toString());
        }
        return result;
    }

    public PairList getTransports() {
        PairList result = new PairList(16);
        Iterator i = this.mModules.valueIterator();
        while (i.hasNext()) {
            ModuleDefinition md = (ModuleDefinition)i.next();
            List transports = md.getReadable().getTexts("module/transports/transport", true);
            Iterator j = transports.iterator();
            while (j.hasNext()) {
                String transport = (String)j.next();
                result.put(transport, md);
            }
        }
        return result;
    }

    public MappedRequest getAccessorForRequest(URRequest aRequest, boolean aDebug) throws NetKernelException {
        boolean shouldLog = SysLogger.shouldLog(4, this);
        if (shouldLog) {
            aDebug = true;
        }
        MappedRequest request = null;
        if (!aDebug) {
            request = this.mMappingCache.get(aRequest);
        }
        if (request == null) {
            List superStack;
            ModuleDefinition module = (ModuleDefinition)aRequest.getContext();
            ArrayList lookedAtModules = new ArrayList(16);
            ArrayList<MappingDebug> debug = null;
            if (aDebug) {
                debug = new ArrayList<MappingDebug>(128);
                debug.add(new MappingDebug(0, aRequest.getURI()));
                debug.add(new MappingDebug(1, module));
            }
            boolean rewrite = (superStack = aRequest.getSuperStackClone()).size() == 0;
            request = this.getAccessorInModule(module, aRequest.rewrite(aRequest.getURI()), rewrite, lookedAtModules, superStack, debug);
            if (request == null) {
                request = new MappedRequest(null, aRequest);
                if (aDebug) {
                    debug.add(new MappingDebug(8, aRequest.getURI()));
                }
            } else {
                this.mMappingCache.put(aRequest, request);
            }
            if (aDebug) {
                request.setDebug(debug);
                if (shouldLog) {
                    Iterator i = debug.iterator();
                    while (i.hasNext()) {
                        MappingDebug md = (MappingDebug)i.next();
                        SysLogger.log(4, this, md.toString());
                    }
                }
            }
        }
        return request;
    }

    private MappedRequest getAccessorInModule(ModuleDefinition aModule, URRequest aRequest, boolean aIsExternal, List aLookedAtModules, List aSuperStack, List aDebug) throws NetKernelException {
        MappedRequest result = null;
        boolean visitedAlready = aLookedAtModules.contains(aModule);
        if (!visitedAlready || !aIsExternal) {
            ModuleDefinition md;
            aLookedAtModules.add(aModule);
            URIdentifier uri = aRequest.getURI();
            if (aIsExternal && (uri = aModule.rewrite(uri)) != aRequest.getURI()) {
                aLookedAtModules.clear();
                if (aDebug != null) {
                    aDebug.add(new MappingDebug(2, uri));
                }
            }
            String uriString = uri.toString();
            URIMapping mapping = null;
            URIMapping[] mappings = aModule.getMappings();
            for (int i = 0; i < mappings.length; ++i) {
                URIMapping mapping2 = mappings[i];
                md = mapping2.getImportModule();
                int debugCode = 5;
                if (md == null || !aLookedAtModules.contains(md)) {
                    if (mapping2.matches(uriString)) {
                        RegexRewriterRule rewrite = mapping2.getRewriterRule();
                        if (rewrite != null) {
                            debugCode = 2;
                            uri = rewrite.map(uri);
                            uriString = uri.toString();
                            aLookedAtModules.clear();
                            mapping2 = null;
                            if (aDebug != null) {
                                aDebug.add(new MappingDebug(debugCode, uriString));
                            }
                        } else if (mapping2.getSkipCount() > 0) {
                            debugCode = 9;
                            i += mapping2.getSkipCount();
                        } else {
                            debugCode = 7;
                            mapping = mapping2;
                        }
                    } else {
                        debugCode = 6;
                        if (md != null) {
                            aLookedAtModules.add(md);
                        }
                    }
                }
                if (aDebug != null && mapping2 != null) {
                    aDebug.add(new MappingDebug(debugCode, mapping2));
                }
                if (mapping != null) break;
            }
            URRequest request = uri != aRequest.getURI() ? aRequest.rewrite(uri) : aRequest;
            if (mapping != null) {
                int superSize;
                if (mapping.getImportModule() != null) {
                    ModuleDefinition md2 = mapping.getImportModule();
                    aSuperStack.add(aModule);
                    if (aDebug != null) {
                        aDebug.add(new MappingDebug(3, md2));
                    }
                    result = this.getAccessorInModule(md2, request, true, aLookedAtModules, aSuperStack, aDebug);
                } else if (mapping.getURAClass() != null) {
                    String accessorClassString = mapping.getURAClass();
                    URRequest accessorRequest = AccessorFactory.getAccessorRequest(aModule, accessorClassString, aRequest);
                    request.setCurrentContext(aModule, aSuperStack);
                    accessorRequest.setCurrentContext(aModule, aSuperStack);
                    result = new MappedRequest(accessorRequest, request);
                } else if (mapping.getType() == 1) {
                    URRequest accessorRequest = AccessorFactory.getAccessorRequest(aModule, (class$com$ten60$netkernel$module$accessor$ModuleResourceAccessor == null ? (class$com$ten60$netkernel$module$accessor$ModuleResourceAccessor = ModuleManager.class$("com.ten60.netkernel.module.accessor.ModuleResourceAccessor")) : class$com$ten60$netkernel$module$accessor$ModuleResourceAccessor).getName(), aRequest);
                    request.setCurrentContext(aModule, aSuperStack);
                    accessorRequest.setCurrentContext(aModule, aSuperStack);
                    result = new MappedRequest(accessorRequest, request);
                }
                if (result == null && mapping.getType() == 2 && !aIsExternal && (superSize = aSuperStack.size()) > 0) {
                    md = (ModuleDefinition)aSuperStack.remove(superSize - 1);
                    if (aDebug != null) {
                        aDebug.add(new MappingDebug(4, md));
                    }
                    result = this.getAccessorInModule(md, request, false, aLookedAtModules, aSuperStack, aDebug);
                }
            }
        }
        return result;
    }

    public ITransrepresentor getTransrepresentorFor(IURRepresentation aFrom, Class aTo, URRequest aRequest) {
        int superSize;
        ModuleDefinition md = (ModuleDefinition)aRequest.getContext();
        ArrayList lookedAtModules = new ArrayList(16);
        List superStack = aRequest.getSuperStackClone();
        ITransrepresentor result = null;
        while ((result = md.getTransrepresentorFor(aFrom, aTo, lookedAtModules)) == null && (superSize = superStack.size()) > 0) {
            md = (ModuleDefinition)superStack.remove(superSize - 1);
        }
        return result;
    }

    public IFragmentor getFragmentorFor(URRequest aRequest) {
        int superSize;
        ModuleDefinition md = (ModuleDefinition)aRequest.getContext();
        ArrayList lookedAtModules = new ArrayList(16);
        List superStack = aRequest.getSuperStackClone();
        IFragmentor result = null;
        while ((result = md.getFragmentorFor(aRequest, lookedAtModules)) == null && (superSize = superStack.size()) > 0) {
            md = (ModuleDefinition)superStack.remove(superSize - 1);
        }
        return result;
    }

    URL expandNestedJar(JarFile aJarFile, ZipEntry aEntry, URIdentifier aURI, Version aVersion) throws IOException, MalformedURLException {
        if (this.mExpandedJarDir == null) {
            Config config = (Config)this.mContainer.getComponent(Config.URI);
            String relDir = config.getReadable().getText("system/expandedJarPool").trim();
            this.mExpandedJarDir = new File(this.mContainer.getBasePath(), relDir);
        }
        String filename = aURI.toString() + aVersion.toString(3) + aEntry.getName().substring(3);
        StringBuffer sb = new StringBuffer(filename.length() + 4);
        for (int i = 0; i < filename.length(); ++i) {
            char c = filename.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                sb.append(c);
                continue;
            }
            sb.append('_');
        }
        sb.append(JAR_SUFFIX);
        filename = sb.toString();
        File jarFile = new File(this.mExpandedJarDir, filename);
        if (!jarFile.exists()) {
            SysLogger.log1(6, this, "    expanding nested jar [%1]", aEntry.getName());
            FileOutputStream fos = null;
            InputStream is = null;
            fos = new FileOutputStream(jarFile);
            is = aJarFile.getInputStream(aEntry);
            Utils.pipe(is, fos);
        }
        return new URL(jarFile.toURI().toString());
    }

    public void write(OutputStream aStream) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(aStream);
        osw.write("<modules>");
        this.writeKernelModule(osw);
        Iterator i = this.mModules.valueIterator();
        while (i.hasNext()) {
            ModuleDefinition md = (ModuleDefinition)i.next();
            md.write(osw);
        }
        osw.write("</modules>");
        osw.flush();
    }

    private void writeKernelModule(Writer aWriter) throws IOException {
        aWriter.write("<module>");
        aWriter.write("<identity>");
        aWriter.write("<uri>");
        aWriter.write("urn:com:ten60:netkernel");
        aWriter.write("</uri>");
        aWriter.write("<version>");
        aWriter.write("2.6.2");
        aWriter.write("</version>");
        aWriter.write("</identity>");
        aWriter.write("<info>");
        aWriter.write("<name>NetKernel</name>");
        aWriter.write("<description>NetKernel microkernel</description>");
        aWriter.write("<timestamp>0</timestamp>");
        aWriter.write("<source>");
        URL url = this.mContainer.getKernelSourceURL();
        if (url != null) {
            aWriter.write(XMLUtils.escape(url.toString()));
        }
        aWriter.write("</source>");
        aWriter.write("</info>");
        aWriter.write("</module>");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

