<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html"/>
	
	<xsl:param name="param"/>
	
    <xsl:template match="/">
<html>
	<head>
		<link href="icon.png" rel="SHORTCUT ICON"  />
	</head>
	<body>
		<style type="text/css">
		input {width: 350px;}
		input.button {width: 50px;}
		</style>
		<h1>Setup Mailbox and SMTP Server</h1>
		<form action="services/process-config.idoc" method="POST" style="border: 1px solid silver; padding: 2px;"> 
			<table>
				<tr>
					<td colspan="2"><h2>Mailbox</h2></td>
				</tr>
				<tr>
					<td>Host</td>
					<td>
						<input name="hostname">
							<xsl:attribute name="value"><xsl:value-of select="mailProcessorStatus/mailProcessor/host"/></xsl:attribute>
						</input>
					</td>
				</tr>
				<tr>
					<td>Login Name</td>
					<td>
						<input name="username">
							<xsl:attribute name="value"><xsl:value-of select="mailProcessorStatus/mailProcessor/username"/></xsl:attribute>
						</input>
					</td>
				</tr>
				<tr>
					<td>Password</td>
					<td>
						<input name="password" type="password">
							<xsl:attribute name="value"><xsl:value-of select="mailProcessorStatus/mailProcessor/password"/></xsl:attribute>
						</input>
					</td>
				</tr>
				<tr>
					<td>Type</td>
					<td>
						<select name="type">
						<option value="pop">
							<xsl:if test="mailProcessorStatus/mailProcessor/type = 'pop'"><xsl:attribute name="selected">true</xsl:attribute></xsl:if>POP3
						</option>
						<option value="imap">
							<xsl:if test="mailProcessorStatus/mailProcessor/type = 'imap'"><xsl:attribute name="selected">true</xsl:attribute></xsl:if>IMAP
						</option>
						</select>
					</td>
				</tr>
				<tr>
					<td>Processing URI</td>
					<td>
						<input name="uri" value="active:dpml+operand@ffcpl:/resources/services/autoreply.idoc">
							<xsl:choose>
								<xsl:when test="mailProcessorStatus/mailProcessor/processURI">
									<xsl:attribute name="value"><xsl:value-of select="mailProcessorStatus/mailProcessor/processURI"/></xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="value"><xsl:value-of select="mailProcessorStatus/mailProcessor/username"/></xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>
						</input>
					</td>
				</tr>
			</table>
			<table>
				<tr>
					<td colspan="2"><h2>SMTP Mail Server</h2></td>
				</tr>
				<tr>
					<td>SMTP Gateway</td>
					<td>
						<input name="SMTPhostname">
							<xsl:attribute name="value"><xsl:value-of select="$param/SMTPConfig/SMTPGateway"/></xsl:attribute>
						</input>
					</td>
				</tr>
				<tr>
					<td>Login Name</td>
					<td>
						<input name="SMTPusername">
							<xsl:if test="$param/SMTPConfig/SMTPUser">
								<xsl:attribute name="value"><xsl:value-of select="$param/SMTPConfig/SMTPUser"/></xsl:attribute>
							</xsl:if>
						</input>
					</td>
				</tr>
				<tr>
					<td>Password</td>
					<td>
						<input name="SMTPpassword" type="password">
							<xsl:if test="$param/SMTPConfig/SMTPPassword">
								<xsl:attribute name="value"><xsl:value-of select="$param/SMTPConfig/SMTPPassword"/></xsl:attribute>
							</xsl:if>
						</input>
					</td>
				</tr>
			</table>
			<input class="button" type="submit"/>
		</form>
		<h3>Notes</h3>
		<p>
		<b>Mailbox</b> is the POP or IMAP server which will receive incoming mail messages.<br/>
		<b>Processing URI</b> is the netkernel service URI which will be invoked for each message
		received in the mailbox.
		</p>
		<p>
		<b>SMTP Mail Server</b> is the SMTP mail server from which outgoing emails will be sent.
		</p>
		<p>
		<span style="color: red;">Note</span> this application's email processor is configured to
		delete the incoming email (necessary to prevent resubmission of emails with pop mailboxes).
		Make sure to use a test mailbox which you don't expect important mail at if you use this application!
		</p>
	</body>
</html>
    </xsl:template>

</xsl:stylesheet>
