/*
 * RandomSelector.java
 *
 * This is the default "generic" random song selector originally found in
 * Streamsicle.  It simply picks any song from it's list of available files,
 * irrespective of how many times or the last time a song was requested.
 *
 * Created on February 16, 2002, 12:24 PM
 */

package com.streamsicle;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;

public class RandomSelector implements IRandomSelector {
    Vector availableSongIDs = new Vector();
    Random randomGen = new Random();

    public void addRequestedSongID(int songID) {
        // do nothing for requests
    }

    public void setAvailableFiles(Vector availableFiles) {
        availableSongIDs = new Vector();
        for (Enumeration en = availableFiles.elements(); en.hasMoreElements(); ) {
            MP3File mFile = (MP3File)en.nextElement();
            availableSongIDs.addElement(new Integer(mFile.getFileID()));
        }
    }

    // only add songs if no requests have been submitted as of yet
    // this IRandomSelector ignores song requests when calculating the next random
    // song to return
    public void addToAvailableSongs(int songID) {
        availableSongIDs.addElement(new Integer(songID));
    }

    public Integer getNextSongID() {
        Integer objectID = (Integer)(availableSongIDs.elementAt(
            Math.abs(randomGen.nextInt()) % availableSongIDs.size()) );
        return objectID;
    }
}

