package com.streamsicle.fluid;

/**
 * <P>Interface implemented by any class that will be receiving meta data from
 * the stream.  Includes one method, setMetaData, which will be called whenever
 * new meta data is available.</P>
 *
 * <P>For shoutcast streams meta data is sent every <I>x</I> bytes, where
 * <I>x</I> is the amount sent back to the client in the "icy-metaint" header.
 * If there is no new meta data to send, then an empty/0 byte is sent.  If
 * there is meta data to be sent to the client, then the first byte of the meta
 * data is the size of the meta data, in bytes, divided by sixteen.  After that
 * comes the track info (null terminated), then the track URL (usually unused,
 * and unused here as well).  Then padding to make the size of the meta data a
 * multiple of sixteen.</P>
 *
 * <P>Example: <BR>
 * <CODE><I>X</I>StreamTitle='Sample Title';StreamUrl='http://url/';</CODE><BR>
 * where <I>X</I> is a single byte containing the size of the meta data (not
 * including the size byte) divided by sixteen.  Also, the meta data should
 * be padded with extra space to make its size a multiple of sixteen.</P>
 *
 * @author Dan Heller (dan@streamsicle.com)
 */
public interface IMetaDataListener {
   /**
    * Interval between meta data sent to the client.
    */
   // DSH TODO: put this in the fluid.config file...
   public static final int META_DATA_INTERVAL = 8192;

   /**
    * Called whenever new meta data is available to be sent to the client
    * @param metaData The meta data in shoutcast format.
    */
   public void setMetaData( byte[] metaData );
}
