/*
 * randomWithHistorySelector.java
 *
 * This random selector will randomly select songs from its list of
 * available files without repetition until all available files have been
 * selected one time each.  When all files have been selected, all files
 * become available for selection again, and the process repeats.
 * This random selector also ignores user requests when calculating the next
 * songID to return.
 *
 * Created on February 16, 2002, 2:29 PM
 */

package com.streamsicle;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;

import org.ten60.orchextra.*;

// Import log4j classes.

public class RandomWithHistorySelector implements IRandomSelector {
    Vector availableSongIDs = null, originalSongList = new Vector();
    Random randomGen = new Random();
    boolean noSongsRequested = true;

    public void addRequestedSongID(int songID) {
        // do nothing for requests
    }

    // only add songs if no requests have been submitted as of yet
    // this IRandomSelector ignores song requests when calculating the next random
    // song to return
    public void addToAvailableSongs(int songID) {
        originalSongList.addElement(new Integer(songID));
    }

    private void initAvailableSongsList() {
        try {
            availableSongIDs = (Vector)originalSongList.clone();
        } catch (Exception e) {
            OrchextraAccessor.log(OrchextraAccessor.SEVERE, this, "Couldn't get availableSong list!!");
        }
    }

    public void setAvailableFiles(Vector availableFiles) {
        availableSongIDs = new Vector();
        originalSongList = new Vector();
        for (Enumeration enum = availableFiles.elements(); enum.hasMoreElements(); ) {
            MP3File mFile = (MP3File)enum.nextElement();
            availableSongIDs.addElement(new Integer(mFile.getFileID()));
            originalSongList.addElement(new Integer(mFile.getFileID()));
        }
    }

    public Integer getNextSongID() {
        if (noSongsRequested) {
            // make a copy of the original list of songs so that it can
            // be restored later
            initAvailableSongsList();
            noSongsRequested = false;
        }
        // before a new song is selected, make sure all the original songs in
        // the list haven't already been selected
        if (availableSongIDs.size() == 0) {
            initAvailableSongsList();
        }
        // grab a new song from the list
        Integer objectID = (Integer)(availableSongIDs.elementAt(
            Math.abs(randomGen.nextInt()) % availableSongIDs.size()) );
        // remove the song just selected so it isn't selected again
        availableSongIDs.removeElement(objectID);

        return objectID;
    }

}
