/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: XFormsAccessor.java,v $
  Version:       $Name:  $ $Revision: 1.6 $
  Last Modified: $Date: 2003/11/04 16:36:15 $
 *****************************************************************************/

package org.ten60.netkernel.xforms.accessor;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.log4j.MDC;
import org.chiba.xml.xforms.ChibaBean;
import org.ten60.netkernel.layer1.meta.AlwaysExpiredMeta;
import org.ten60.netkernel.layer1.representation.ByteArrayAspect;
import org.ten60.netkernel.layer1.representation.IAspectMultipart;
import org.ten60.netkernel.layer1.representation.MultiPartAspect;
import org.ten60.netkernel.layer1.util.CompoundURIdentifier;
import org.ten60.netkernel.xforms.adaptor.ura.URAAdaptor;
import org.ten60.netkernel.xforms.adaptor.ura.URAContext;
import org.ten60.netkernel.xforms.connector.NKDummySubmissionDriver;
import org.ten60.netkernel.xforms.representation.ChibaBeanAspect;
import org.ten60.netkernel.xforms.representation.IAspectChibaBean;
import org.ten60.netkernel.xml.xahelper.XAHelper;
import org.ten60.netkernel.xml.xahelper.XAHelperExtra;
import org.ten60.netkernel.xml.xahelper.XAccessor;
import org.ten60.netkernel.xml.xda.IXDAReadOnly;
import org.ten60.netkernel.xml.xda.IXDAReadOnlyIterator;

import com.ten60.netkernel.urii.IURAspect;
import com.ten60.netkernel.urii.IURRepresentation;
import com.ten60.netkernel.urrequest.URRequest;
import com.ten60.netkernel.util.SysLogger;

/**
 *	An XForms Accessor which uses the Chiba XFroms engine
 * @author  pjr
 */
public class XFormsAccessor extends XAccessor {
	private static XAHelper mHelper;

	private static final String BASE_INSTANCE_PARAM_NAME = "instance-";
	private static final int BASE_INSTANCE_PARAM_NAME_LEN =
		BASE_INSTANCE_PARAM_NAME.length();
	private static final String BASE_SUBMISSION_ACTION_PARAM_NAME =
		"submission-action-";
	private static final int BASE_SUBMISSION_ACTION_PARAM_NAME_LEN =
		BASE_SUBMISSION_ACTION_PARAM_NAME.length();

	/** Creates a new instance of XFormsAccessor */
	public XFormsAccessor() {
		declareArgument(OPERAND, false, false);
		declareArgument(OPERATOR, false, false);
		declareArgument(PARAMETER, false, false);
		declareForgetDependencies();
	}

	/** Abstract method to be implemented in subclass.
	 * @return Either the result as a Document or a Reader.
	 * @param aHelper The helper class that provides access to the operator,
	 * operand, and parameters.
	 * @throws AccessViolationException Thrown if we fail to access any of the beans
	 * @throws Exception Thrown if we fail for any reason.
	 *
	 */
	public IURRepresentation source(XAHelper aHelper) throws Throwable {
		mHelper = aHelper;

		ClassLoader oldcl = Thread.currentThread().getContextClassLoader();
		Thread.currentThread().setContextClassLoader(
			this.getClass().getClassLoader());

		try {

			// setup the log4j mapped diagnostic context 
			// Traverse the call stack to get the most relevant request & cwu
			XAHelperExtra extra = (XAHelperExtra) aHelper;
			URRequest req = extra.getRequest();
			req = req.getParent();
			MDC.put("URI", req.getCWU());

			IURRepresentation result = null;
			IURRepresentation main = null;

			if (aHelper.getType().equals("buildXForm")) {
				ChibaBean cb = getChibaInstance(aHelper, null, null);
				result =
					ChibaBeanAspect.create(
						aHelper.getDependencyMeta("application/xform", 4),
						cb);
			} else //Process
				{
				IURRepresentation opt = aHelper.getOperator(IURAspect.class);
				ChibaBean cb = null;
				if (opt.hasAspect(IAspectChibaBean.class)) {
					IAspectChibaBean cbAspect =
						(IAspectChibaBean) opt.getAspect(
							IAspectChibaBean.class);
					cb = cbAspect.getChibaBean();
				} else if (opt.hasAspect(IAspectMultipart.class)) {
					IAspectMultipart mp =
						(IAspectMultipart) opt.getAspect(
							IAspectMultipart.class);
					IURRepresentation[] parts = mp.getParts();
					for (int i = 0; i < parts.length; i++) {
						if (parts[i].hasAspect(IAspectChibaBean.class)) {
							IAspectChibaBean cbAspect =
								(IAspectChibaBean) parts[i].getAspect(
									IAspectChibaBean.class);
							cb = cbAspect.getChibaBean();
							break;
						}
					}
				}
				if (cb == null)
					throw new Exception("Must supply a ChibaBean XForm as operator");

				//Turn NVP parameters into Chiba requestMap

				if (aHelper.hasParameter()) {
					IXDAReadOnly params = aHelper.getParameter().getXDA();
					int paramCount =
						Integer.parseInt(
							params.eval("count(/nvp/*)").getStringValue());

					IXDAReadOnlyIterator it =
						aHelper.getParameter().getXDA().readOnlyIterator(
							"/nvp/*");
					Map requestMap = new HashMap();
					while (it.hasNext()) {
						it.next();
						String name = it.eval("name()").getStringValue();
						ArrayList values = (ArrayList) requestMap.get(name);
						if (values == null) {
							values = new ArrayList(3);
						}
						values.add(it.getText(".", false));
						requestMap.put(name, values);
					}
					//Convert ArrayLists to String[]
					Iterator i = requestMap.keySet().iterator();
					while (i.hasNext()) {
						Object key = i.next();
						ArrayList values = (ArrayList) requestMap.get(key);
						String strvalues[] = new String[values.size()];
						for (int j = 0; j < strvalues.length; j++) {
							strvalues[j] = (String) values.get(j);
						}
						requestMap.put(key, strvalues);
					}

					// handle request and submission response
					//RequestController controller = new RequestController(requestMap, chibaProcessor);
					//Map submissionResponse = controller.handleRequest();
					//DOMXDA doc=new DOMXDA(XMLUtils.getInstance().newDocument(),false);

                    URAContext uraContext = (URAContext)cb.getContext();
                    URAAdaptor uraAdaptor = uraContext.getURAAdaptor();
					uraAdaptor.handleRequest(requestMap);

					if (uraAdaptor.hasForward()) {
						System.err.println("We've been forwarded");
						// fetch response stream
						Map forwardResponse = uraAdaptor.getForwardMap();

						StringBuffer sb = new StringBuffer(2048);
						sb.append("<XFormResult><type>forward</type>");
						sb.append(
							(String) forwardResponse.remove(
								NKDummySubmissionDriver.NK_FORWARD_PAYLOAD));
						sb.append("</XFormResult>");
						main =
							ByteArrayAspect.create(
								aHelper.getDependencyMeta("text/xml", 16),
								sb.toString().getBytes());

					} else if (uraAdaptor.hasRedirect()) {
						System.err.println(
							"We've been redirected to " + uraAdaptor.getRedirectUri());
						StringBuffer sb =
							new StringBuffer("<XFormResult><type>redirect</type>");
						sb.append("<uri>");
						sb.append(uraAdaptor.getRedirectUri());
						sb.append("</uri>");
						sb.append("</XFormResult>");
						main =
							ByteArrayAspect.create(
								aHelper.getDependencyMeta("text/xml", 16),
								sb.toString().getBytes());

					} else { //The form is still not processed.
						StringBuffer sb = new StringBuffer(2048);
						sb.append("<XFormResult><type>xform</type>");
						sb.append("<xform>");
						sb.append(cb.getXMLContainerAsString());
						sb.append("</xform>");
						sb.append("</XFormResult>");
						main =
							ByteArrayAspect.create(
								aHelper.getDependencyMeta("text/xml", 16),
								sb.toString().getBytes());
					}

				}

				ArrayList parts = new ArrayList(1);
				parts.add(
					ChibaBeanAspect.create(
						new AlwaysExpiredMeta("application/xform", 4),
						cb));
				result = MultiPartAspect.create(main, parts);
				mHelper = null;

			}

			Thread.currentThread().setContextClassLoader(oldcl);
			return result;
		} catch (Throwable t) { //Swap classloader back or we end up with DOM incompatibilities
			Thread.currentThread().setContextClassLoader(oldcl);
			//t.printStackTrace();
			throw t;
		} finally {
			// remove any MDC prevously setup
			MDC.remove("URI");
		}

	}

	public static XAHelper getHelper() {
		return mHelper;
	}

	private ChibaBean getChibaInstance(
		XAHelper aHelper,
		String chibaFormUri,
		String chibaInstanceUri)
		throws Exception {

		// [1] get request/context wrappers

		ChibaBean chibaBean = new ChibaBean();

		String baseUrl = null;
		chibaBean.setBaseURI("http://localhost:8080/test/xform/");

		// chibaBean.setConfig(configPath);
		//URIResolver resolver = (URIResolver) ConnectorFactory.getInstance().createConnector(ConnectorFactory.RESOLVER, chibaFormUri);
		//Document form = (Document) XMLUtils.getInstance().safeDeepClone(aHelper.getOperand().getReadOnlyDocument());
		IXDAReadOnly form = aHelper.getOperand().getXDA();

		// [6] check for instance uri
		/*
		if (chibaInstanceUri != null && chibaInstanceUri.length() > 0) {
		    if (LOGGER.isDebugEnabled()) {
		        LOGGER.debug("setting instance uri '" + chibaInstanceUri + "'");
		    }
		
		    JXPathContext formContext = JXPathContext.newContext(form);
		    Pointer modelPointer = formContext.getPointer("//xforms:model[1]");
		    JXPathContext modelContext = formContext.getRelativeContext(modelPointer);
		    Pointer instancePointer = modelContext.getPointer("xforms:instance");
		
		    if (instancePointer.getNode() == null) {
		        instancePointer = modelContext.createPath("xforms:instance");
		    }
		
		    Element instance = (Element) instancePointer.getNode();
		    instance.setAttributeNS(NamespaceCtx.XFORMS_NS, "xforms:src", chibaInstanceUri);
		}
		 */

		// [7] set containing document
        

		URAAdaptor uraAdaptor = new URAAdaptor();
		uraAdaptor.setChibaBean(chibaBean);

		StringWriter sw = new StringWriter();
		form.serialize(sw, false);
		ByteArrayInputStream bais =
			new ByteArrayInputStream(sw.getBuffer().toString().getBytes());
		chibaBean.setXMLContainer(bais);

		///////////////////////////////////////
		//New code to configure instance/submission URIs from the request
		//Uses Robert Leftwich's proposed interface definition.
		//////////////////////////////////////
		XAHelperExtra extra = (XAHelperExtra) aHelper;
		URRequest req = extra.getRequest();
		req = req.getParent();
		CompoundURIdentifier curi = new CompoundURIdentifier(req.getURI());
		Iterator i = curi.getArgs();
		while (i.hasNext()) {
			CompoundURIdentifier.CompoundURIStruct struct =
				(CompoundURIdentifier.CompoundURIStruct) i.next();
			String key = struct.getKey();
			if (key.startsWith(BASE_INSTANCE_PARAM_NAME)) {
				String instanceID =
					key.substring(BASE_INSTANCE_PARAM_NAME_LEN);
				String instanceURI = struct.getURI();
				SysLogger.log2(
					SysLogger.INFO,
					this,
					"Setting instance uri: %1 : %2",
					instanceID,
					instanceURI);
				chibaBean.setInstanceURI(instanceID, instanceURI);
			} else if (key.startsWith(BASE_SUBMISSION_ACTION_PARAM_NAME)) {
				String submissionID =
					key.substring(BASE_SUBMISSION_ACTION_PARAM_NAME_LEN);
				String submissionURI = struct.getURI();
				SysLogger.log2(
					SysLogger.INFO,
					this,
					"Setting submission uri: %1 : %2",
					submissionID,
					submissionURI);
				chibaBean.setSubmissionURI(submissionID, submissionURI);
			}
		}

		chibaBean.init();

		return chibaBean;
	}

}
