/*
 *
 *    Artistic License
 *
 *    Preamble
 *
 *    The intent of this document is to state the conditions under which a Package may be copied, such that
 *    the Copyright Holder maintains some semblance of artistic control over the development of the
 *    package, while giving the users of the package the right to use and distribute the Package in a
 *    more-or-less customary fashion, plus the right to make reasonable modifications.
 *
 *    Definitions:
 *
 *    "Package" refers to the collection of files distributed by the Copyright Holder, and derivatives
 *    of that collection of files created through textual modification.
 *
 *    "Standard Version" refers to such a Package if it has not been modified, or has been modified
 *    in accordance with the wishes of the Copyright Holder.
 *
 *    "Copyright Holder" is whoever is named in the copyright or copyrights for the package.
 *
 *    "You" is you, if you're thinking about copying or distributing this Package.
 *
 *    "Reasonable copying fee" is whatever you can justify on the basis of media cost, duplication
 *    charges, time of people involved, and so on. (You will not be required to justify it to the
 *    Copyright Holder, but only to the computing community at large as a market that must bear the
 *    fee.)
 *
 *    "Freely Available" means that no fee is charged for the item itself, though there may be fees
 *    involved in handling the item. It also means that recipients of the item may redistribute it under
 *    the same conditions they received it.
 *
 *    1. You may make and give away verbatim copies of the source form of the Standard Version of this
 *    Package without restriction, provided that you duplicate all of the original copyright notices and
 *    associated disclaimers.
 *
 *    2. You may apply bug fixes, portability fixes and other modifications derived from the Public Domain
 *    or from the Copyright Holder. A Package modified in such a way shall still be considered the
 *    Standard Version.
 *
 *    3. You may otherwise modify your copy of this Package in any way, provided that you insert a
 *    prominent notice in each changed file stating how and when you changed that file, and provided that
 *    you do at least ONE of the following:
 *
 *        a) place your modifications in the Public Domain or otherwise make them Freely
 *        Available, such as by posting said modifications to Usenet or an equivalent medium, or
 *        placing the modifications on a major archive site such as ftp.uu.net, or by allowing the
 *        Copyright Holder to include your modifications in the Standard Version of the Package.
 *
 *        b) use the modified Package only within your corporation or organization.
 *
 *        c) rename any non-standard executables so the names do not conflict with standard
 *        executables, which must also be provided, and provide a separate manual page for each
 *        non-standard executable that clearly documents how it differs from the Standard
 *        Version.
 *
 *        d) make other distribution arrangements with the Copyright Holder.
 *
 *    4. You may distribute the programs of this Package in object code or executable form, provided that
 *    you do at least ONE of the following:
 *
 *        a) distribute a Standard Version of the executables and library files, together with
 *        instructions (in the manual page or equivalent) on where to get the Standard Version.
 *
 *        b) accompany the distribution with the machine-readable source of the Package with
 *        your modifications.
 *
 *        c) accompany any non-standard executables with their corresponding Standard Version
 *        executables, giving the non-standard executables non-standard names, and clearly
 *        documenting the differences in manual pages (or equivalent), together with instructions
 *        on where to get the Standard Version.
 *
 *        d) make other distribution arrangements with the Copyright Holder.
 *
 *    5. You may charge a reasonable copying fee for any distribution of this Package. You may charge
 *    any fee you choose for support of this Package. You may not charge a fee for this Package itself.
 *    However, you may distribute this Package in aggregate with other (possibly commercial) programs as
 *    part of a larger (possibly commercial) software distribution provided that you do not advertise this
 *    Package as a product of your own.
 *
 *    6. The scripts and library files supplied as input to or produced as output from the programs of this
 *    Package do not automatically fall under the copyright of this Package, but belong to whomever
 *    generated them, and may be sold commercially, and may be aggregated with this Package.
 *
 *    7. C or perl subroutines supplied by you and linked into this Package shall not be considered part of
 *    this Package.
 *
 *    8. The name of the Copyright Holder may not be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 *    9. THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
 *    WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 *    MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 */
package org.chiba.xml.xforms.xpath.test;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

/**
 * Test-cases for ValidatorTest
 * @author joern turner (joernt@chiba.sourceforge.net)
 */
public class JXPathTest extends TestCase {
	/**
	 * Creates a new JXPathTest object.
	 *
	 * @param name __UNDOCUMENTED__
	 */
	public JXPathTest(String name) {
		super(name);
	}

	/**
	 * __UNDOCUMENTED__
	 *
	 * @return __UNDOCUMENTED__
	 */
	public String getTest() {
		return "test";
	}

	/**
	 * __UNDOCUMENTED__
	 *
	 * @param args __UNDOCUMENTED__
	 */
	public static void main(String[] args) {
		junit.textui.TestRunner.run(suite());
	}

	/**
	 * __UNDOCUMENTED__
	 *
	 * @return __UNDOCUMENTED__
	 */
	public static Test suite() {
		return new TestSuite(JXPathTest.class);
	}

    public void testLast () throws Exception {
        Document doc = getXmlResource("instance.xml");
        JXPathContext context = JXPathContext.newContext(doc);
        Pointer pointer1 = context.getPointer("//my:order/my:item[2]");
        assertTrue(pointer1.asPath(), pointer1.asPath().equals("/instance[1]/my:order[1]/my:item[2]"));

        Pointer pointer2 = context.getPointer("//my:order/my:item[position()=count(../*)]");
        assertTrue(pointer2.asPath(), pointer2.asPath().equals("/instance[1]/my:order[1]/my:item[2]"));
//
        Pointer pointer3 = context.getPointer("//my:order/my:item[position()=2]");
        assertTrue(pointer3.asPath(),pointer3.asPath().equals("/instance[1]/my:order[1]/my:item[2]"));

        Pointer pointer4 = context.getPointer("//my:order[1]/my:item[last()]");
        assertTrue(pointer4.asPath(),pointer4.asPath().equals("/instance[1]/my:order[1]/my:item[2]"));
    }

	/**
	 * __UNDOCUMENTED__
	 *
	 * @throws Exception __UNDOCUMENTED__
	 */
	public void testCalculate() throws Exception {
		Document doc = getXmlResource("instance.xml");
		JXPathContext rootContext = JXPathContext.newContext(doc);
		Pointer rootPointer = rootContext.getPointer("/instance/my:order/my:item[2]/my:discount");
		JXPathContext relativeContext = rootContext.getRelativeContext(rootPointer);
		Pointer relativePointer = relativeContext.getPointer("string(count(../../my:item))");

		String calculate = (String)relativePointer.getValue();
		assertTrue("2".equals(calculate));
	}

	/**
	 * test the patched version of DOMNodePointer in JXPath.
	 */
	public void testGetPointer() throws Exception {
		org.w3c.dom.Document doc = getXmlResource("hello.xml");
		JXPathContext context = JXPathContext.newContext(doc);

		//test getting Node for path
		Node n = (Node)context.getPointer("//xforms:submission").getNode();
		assertTrue(n.getLocalName().equals("submission"));
	}

	/**
	 * __UNDOCUMENTED__
	 *
	 * @throws Exception __UNDOCUMENTED__
	 */
	public void testRelativePathes() throws Exception {
		Document doc = getXmlResource("instance.xml");
		JXPathContext context = JXPathContext.newContext(doc);

		String s = context.getPointer("//my:item/my:discount/../my:amount").asPath();
		assertTrue("/instance[1]/my:order[1]/my:item[1]/my:amount[1]".equals(s));

		s = (String)context.getValue("//my:item/my:discount/../my:amount/text()");
		assertTrue("500".equals(s));

		s = context.getPointer("//my:item/./my:discount").asPath();
		assertTrue(s.equals("/instance[1]/my:order[1]/my:item[1]/my:discount[1]"));
	}

	/**
	 * __UNDOCUMENTED__
	 *
	 * @throws Exception __UNDOCUMENTED__
	 */
	public void testRelevant1() throws Exception {
		Document doc = getXmlResource("instance.xml");
		JXPathContext context = JXPathContext.newContext(doc);

		Boolean b = (Boolean)context.getValue("boolean(//my:item/my:discount[../my:money > 100])");
		assertTrue(b.equals(Boolean.FALSE));

		b = (Boolean)context.getValue("boolean(//my:item/my:discount[../@my:money > 10])");
		assertTrue(b.equals(Boolean.TRUE));
	}

	/**
	 * __UNDOCUMENTED__
	 *
	 * @throws Exception __UNDOCUMENTED__
	 */
	public void testRelevant2() throws Exception {
		Document doc = getXmlResource("relevant1.xml");
		JXPathContext context = JXPathContext.newContext(doc);

		Boolean b = (Boolean)context.getValue("boolean(//payment/test/expiry[../@method='cc'])");
		assertTrue(b.equals(Boolean.TRUE));
	}

	/**
	 * __UNDOCUMENTED__
	 *
	 * @throws Exception __UNDOCUMENTED__
	 */
	public void testSimplePathes() throws Exception {
		Document doc = getXmlResource("relevant1.xml");
		JXPathContext context = JXPathContext.newContext(doc);

		String result = (String)context.getValue("//xforms:submission/@id");
		assertTrue(result.equals("debug"));

		//get the same as path
		String path = context.getPointer("//xforms:submission/@id").asPath();
		assertTrue("/html[1]/head[1]/xforms:model[1]/xforms:submission[1]/@id".equals(path));
	}

	/**
	 * __UNDOCUMENTED__
	 *
	 * @throws Exception __UNDOCUMENTED__
	 */
	public void testSimplePathesNS() throws Exception {
		Document doc = getXmlResource("hello.xml");
		JXPathContext context = JXPathContext.newContext(doc);

		//test accessing attribute as value
		String result = (String)context.getValue("//xforms:submission/@id");
		assertTrue(result.equals("debug"));

		//get the same as path
		String path = context.getPointer("//xforms:submission/@id").asPath();
		assertTrue("/envelope[1]/xforms:model[1]/xforms:submission[1]/@id".equals(path));
	}

	/**
	 * __UNDOCUMENTED__
	 *
	 * @throws Exception __UNDOCUMENTED__
	 */
	protected void setUp() throws Exception {
	}

	/**
	 * __UNDOCUMENTED__
	 */
	protected void tearDown() {
	}

	private Document getXmlResource(String fileName) throws Exception {
		//        Parser parser = null;
		//        try {
		//            parser = (ParserWrapper)Class.forName(parserName).newInstance();
		//        }
		//        catch (Exception e) {
		//            parser = null;
		//            System.err.println("error: Unable to instantiate parser ("+parserName+")");
		//        }
		//        DOMParser parser = new DOMParser();
		//        parser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion",false);
		//        parser.setFeature("http://xml.org/sax/features/namespaces", true);
		//
		//        return parser.parse(fileName);
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		factory.setNamespaceAware(true);
		factory.setValidating(false);
		factory.setAttribute("http://apache.org/xml/features/dom/defer-node-expansion", Boolean.FALSE);

		// Create builder.
		DocumentBuilder builder = factory.newDocumentBuilder();

		// Parse files.
		return builder.parse(getClass().getResourceAsStream(fileName));
	}
}
// end of class

