/*
 *
 *    Artistic License
 *
 *    Preamble
 *
 *    The intent of this document is to state the conditions under which a Package may be copied, such that
 *    the Copyright Holder maintains some semblance of artistic control over the development of the
 *    package, while giving the users of the package the right to use and distribute the Package in a
 *    more-or-less customary fashion, plus the right to make reasonable modifications.
 *
 *    Definitions:
 *
 *    "Package" refers to the collection of files distributed by the Copyright Holder, and derivatives
 *    of that collection of files created through textual modification.
 *
 *    "Standard Version" refers to such a Package if it has not been modified, or has been modified
 *    in accordance with the wishes of the Copyright Holder.
 *
 *    "Copyright Holder" is whoever is named in the copyright or copyrights for the package.
 *
 *    "You" is you, if you're thinking about copying or distributing this Package.
 *
 *    "Reasonable copying fee" is whatever you can justify on the basis of media cost, duplication
 *    charges, time of people involved, and so on. (You will not be required to justify it to the
 *    Copyright Holder, but only to the computing community at large as a market that must bear the
 *    fee.)
 *
 *    "Freely Available" means that no fee is charged for the item itself, though there may be fees
 *    involved in handling the item. It also means that recipients of the item may redistribute it under
 *    the same conditions they received it.
 *
 *    1. You may make and give away verbatim copies of the source form of the Standard Version of this
 *    Package without restriction, provided that you duplicate all of the original copyright notices and
 *    associated disclaimers.
 *
 *    2. You may apply bug fixes, portability fixes and other modifications derived from the Public Domain
 *    or from the Copyright Holder. A Package modified in such a way shall still be considered the
 *    Standard Version.
 *
 *    3. You may otherwise modify your copy of this Package in any way, provided that you insert a
 *    prominent notice in each changed file stating how and when you changed that file, and provided that
 *    you do at least ONE of the following:
 *
 *        a) place your modifications in the Public Domain or otherwise make them Freely
 *        Available, such as by posting said modifications to Usenet or an equivalent medium, or
 *        placing the modifications on a major archive site such as ftp.uu.net, or by allowing the
 *        Copyright Holder to include your modifications in the Standard Version of the Package.
 *
 *        b) use the modified Package only within your corporation or organization.
 *
 *        c) rename any non-standard executables so the names do not conflict with standard
 *        executables, which must also be provided, and provide a separate manual page for each
 *        non-standard executable that clearly documents how it differs from the Standard
 *        Version.
 *
 *        d) make other distribution arrangements with the Copyright Holder.
 *
 *    4. You may distribute the programs of this Package in object code or executable form, provided that
 *    you do at least ONE of the following:
 *
 *        a) distribute a Standard Version of the executables and library files, together with
 *        instructions (in the manual page or equivalent) on where to get the Standard Version.
 *
 *        b) accompany the distribution with the machine-readable source of the Package with
 *        your modifications.
 *
 *        c) accompany any non-standard executables with their corresponding Standard Version
 *        executables, giving the non-standard executables non-standard names, and clearly
 *        documenting the differences in manual pages (or equivalent), together with instructions
 *        on where to get the Standard Version.
 *
 *        d) make other distribution arrangements with the Copyright Holder.
 *
 *    5. You may charge a reasonable copying fee for any distribution of this Package. You may charge
 *    any fee you choose for support of this Package. You may not charge a fee for this Package itself.
 *    However, you may distribute this Package in aggregate with other (possibly commercial) programs as
 *    part of a larger (possibly commercial) software distribution provided that you do not advertise this
 *    Package as a product of your own.
 *
 *    6. The scripts and library files supplied as input to or produced as output from the programs of this
 *    Package do not automatically fall under the copyright of this Package, but belong to whomever
 *    generated them, and may be sold commercially, and may be aggregated with this Package.
 *
 *    7. C or perl subroutines supplied by you and linked into this Package shall not be considered part of
 *    this Package.
 *
 *    8. The name of the Copyright Holder may not be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 *    9. THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
 *    WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 *    MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 */
package org.chiba.xml.xforms.ui;

import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.log4j.Category;
import org.apache.xerces.dom.ElementImpl;
import org.chiba.xml.util.DOMUtil;
import org.chiba.xml.xforms.Bind;
import org.chiba.xml.xforms.Initializer;
import org.chiba.xml.xforms.Instance;
import org.chiba.xml.xforms.Model;
import org.chiba.xml.xforms.NamespaceCtx;
import org.chiba.xml.xforms.exception.XFormsException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

/**
 * handles expansion of itemset Elements into their equivalent representations as choices/item
 * structure.
 *
 * todo: integrate / rewrite
 * @author <a href="mailto:ollix@users.sourceforge.net">Oliver Charlet</a>
 * @author <a href="mailto:joernt@users.sourceforge.net">Joern Turner</a>
 * @author <a href="mailto:unl@users.sourceforge.net">Ulrich Nicolas Liss&eacute;</a>
 * @version $Id: Itemset.java,v 1.16 2004/02/13 12:52:55 joernt Exp $
 */
public class Itemset extends BoundElement {
	private static final Category LOGGER = Category.getInstance(Itemset.class);
    private String labelLocation;
    private String valueLocation;
    private boolean copy;
    private int itemCount;
    AbstractFormControl select;

	/**
	 * Creates a new Itemset object.
	 *
	 * @param element the DOM Element
	 * @param model the Model this itemset belongs to
	 */
	public Itemset(Element element, Model model) {
		super(element, model);
	}

    /**
     * Performs element init.
     *
     * @throws XFormsException if any error occurred during init.
     */
    public void init() throws XFormsException {
        if (getLogger().isDebugEnabled()) {
            getLogger().debug(this + " init");
        }

        initializeInstanceNode();
        initializeDataElement();
        initializeItemset();
    }

    /**
     * Performs element update.
     *
     * @throws XFormsException if any error occurred during update.
     */
    public void update() throws XFormsException {
        if (getLogger().isDebugEnabled()) {
            getLogger().debug(this + " update");
        }

        updateItemset();
        updateDataElement();
        updateChildren();
    }

    /**
	 * Returns the binding expression.
	 *
	 * @return the binding expression.
	 */
	public String getBindingExpression() {
//		if (this.element.hasAttributeNS(NamespaceCtx.XFORMS_NS, NODESET_ATTRIBUTE)) {
//			return this.element.getAttributeNS(NamespaceCtx.XFORMS_NS, NODESET_ATTRIBUTE);
//		}
//
//		return null;

        String bindExpr=null;
        if (this.element.hasAttributeNS(NamespaceCtx.XFORMS_NS, BIND_ATTRIBUTE)) {
            String bindId = this.element.getAttributeNS(NamespaceCtx.XFORMS_NS, BIND_ATTRIBUTE);
            Bind bind = (Bind) model.getContainer().lookup(bindId);
            bindExpr = bind.getBindingExpression();

        } else {
            bindExpr = this.element.getAttributeNS(NamespaceCtx.XFORMS_NS, NODESET_ATTRIBUTE);
        }
        return bindExpr;
	}
    /**
     * Checks wether this element has an ui binding.
     * <p>
     * This element has an ui binding if it has a <code>nodeset</code> or a
     * <code>repeat-nodeset</code> attribute.
     *
     * @return <code>true</code> if this element has an ui binding, otherwise
     * <code>false</code>.
     */
    public boolean hasUIBinding() {
        return hasNodesetAttribute();
    }

    /**
     * Checks wether this element has a <code>nodeset</code> attribute.
     *
     * @return <code>true</code> if this element has a <code>nodeset</code>
     * attribute, otherwise <code>false</code>.
     */
    private boolean hasNodesetAttribute() {
        return this.element.hasAttributeNS(NamespaceCtx.XFORMS_NS, NODESET_ATTRIBUTE);
    }

    private void initializeItemset() throws XFormsException {
        initializeChildren();
        storeLocations();
        expand();
    }

    private void updateItemset() throws XFormsException {
        expand();
    }

	/**
	 * expands a single itemset Element to a equivalent choices-list of item Elements but preserving the itemset
     * Element instead of a choice.
	 *
	 * todo: handle deep copy of elements with element 'copy'
	 *
	 * @param itemset - the itemset to expand
	 * @throws org.chiba.xml.xforms.exception.XFormsException
	 */
	public void expand() throws XFormsException {

		int count = 0;
        if(isBound()) {
			String path = getLocationPath();
			Instance instance = this.model.getInstance(getInstanceId());
            JXPathContext instanceContext = instance.getInstanceContext();

            // determining the bound nodeset length
            count = instance.countNodeset(path);
			if (count == 0) {
				getLogger().warn(this + " init: nodeset " + path + " does not exist");

			} else if (getLogger().isDebugEnabled()) {
				getLogger().debug(this + " init: creating " + count + " item " +
				                  ((count == 1)
				                   ? "entry"
				                   : "entries"));
			}

            Set selectedValues = new HashSet();

            if(getSelect() instanceof Select1) {
                selectedValues.add(getSelect().getValue());
            } else {
                StringTokenizer st = new StringTokenizer(getSelect().getValue()," ", false);
                while (st.hasMoreTokens()) {
                    selectedValues.add(st.nextToken());
                }
            }

            Iterator it = instance.getPointerIterator(path);
            int i = 1;
            Element item = (Element) getElement().getFirstChild();


            while (it.hasNext()) {
                Pointer p = (Pointer)it.next();
                //System.out.println("rel context: " + p.asPath());
                JXPathContext relContext = instanceContext.getRelativeContext(p);

                //this is not correct - need binding expression of label/value instead
                if(getLogger().isDebugEnabled()){
                    getLogger().debug(this + " evaluating label path: " + labelLocation);
                    getLogger().debug(this + " evaluating value path: " + valueLocation);
                }

                String value = (String) relContext.getValue(valueLocation);
                String label = (String) relContext.getValue(labelLocation);

                if(getLogger().isDebugEnabled()){
                    getLogger().debug(this + " evaluated label path: " + label);
                    getLogger().debug(this + " evaluated value path: " + value);
                }


                boolean selected = selectedValues.contains(value);

                if (getLogger().isDebugEnabled()) {
                    getLogger().debug(this + "item(" + i + ") label: "
                            + label + " value: " + value);
                }
                if (item != null) {
                    updateItem(item, label, value, selected);
                    item = (Element) item.getNextSibling();
                } else {
                    // if not
                    appendItem(label, value, selected);
                }
                i++;
            }

            // removing unnecessary items
            while (item != null) {
                Element nextItem = (Element) item.getNextSibling();
                if (item instanceof ElementImpl) {
                    Object userData = ((ElementImpl) item).getUserData();
                    if (userData instanceof DataElement) {
                        item = nextItem;
                        continue;
                    }
                }
                DOMUtil.removeChildNode(getElement(), item);
                item = nextItem;
            }

		} else {
			getLogger().warn(this + " init: itemset is not bound");
		}
	}

    private AbstractFormControl getSelect() {
        if(this.select == null) {
            Element element = (Element) getElement().getParentNode();
            while (element != null) {
                if (element instanceof ElementImpl) {
                    ElementImpl elem = (ElementImpl) element;
                    Object userData = elem.getUserData();
                    if(userData instanceof AbstractFormControl) {
                        this.select = (AbstractFormControl) userData;
                        break;
                    }
                }
                element = (Element) element.getParentNode();
            }
        }
        return this.select;
    }

//    private String getRelativeLocation(String location) {
//        String myPrefix = getLocationPath() + "/";
//        if (location.startsWith(myPrefix)) {
//            return location.substring(myPrefix.length());
//        } else if (location.equals(getLocationPath())) {
//            return ".";
//        } else {
//            return location;
//        }
//    }

    private void storeLocations() {
        // store repeat prototype
        if (this.labelLocation == null) {

            NodeList labels = getElement().getElementsByTagNameNS(NamespaceCtx.XFORMS_NS, LABEL);
            if (labels.getLength() >= 1) {
//                this.labelLocation = getRelativeLocation(((BoundElement)((ElementImpl)labels.item(0)).getUserData()).getLocationPath());
                this.labelLocation = getBindExpr((Element)labels.item(0));
                getLogger().debug(this + " label location: " + labelLocation);
            }

            NodeList values = getElement().getElementsByTagNameNS(NamespaceCtx.XFORMS_NS, VALUE);
            if (values.getLength() >= 1) {
//                this.valueLocation = getRelativeLocation(((BoundElement)((ElementImpl)values.item(0)).getUserData()).getLocationPath());
                this.valueLocation = getBindExpr((Element) values.item(0));
                getLogger().debug(this + " value prototype: " + valueLocation);
            }
        }
        // remove original children
        DOMUtil.removeBoundElementChildren(getElement());

        itemCount = 0;
    }

    private String getBindExpr(Element element){
        String bindExpr=null;
        if (element.hasAttributeNS(NamespaceCtx.XFORMS_NS, BIND_ATTRIBUTE)) {
            String bindId = element.getAttributeNS(NamespaceCtx.XFORMS_NS, BIND_ATTRIBUTE);
            Bind bind = (Bind) model.getContainer().lookup(bindId);
            bindExpr = bind.getBindingExpression();

        } else {
            bindExpr = element.getAttributeNS(NamespaceCtx.XFORMS_NS, REF_ATTRIBUTE);
        }
        return bindExpr;
    }

	/**
	 * Returns the logger object.
	 *
	 * @return the logger object.
	 */
	protected Category getLogger() {
		return LOGGER;
	}

	private void appendItem(String label,
                            String value, boolean selected) throws XFormsException {

        Document doc = getElement().getOwnerDocument();

		Element item = doc.createElementNS(NamespaceCtx.XFORMS_NS, NamespaceCtx.getPrefix(element,NamespaceCtx.XFORMS_NS) + ":item");
        setItemSelection(item, selected);

		Element lbl = doc.createElementNS(NamespaceCtx.XFORMS_NS,  NamespaceCtx.getPrefix(element,NamespaceCtx.XFORMS_NS) + ":label");
		lbl.appendChild(doc.createTextNode(label));
		item.appendChild(lbl);

		Element val = doc.createElementNS(NamespaceCtx.XFORMS_NS,  NamespaceCtx.getPrefix(element,NamespaceCtx.XFORMS_NS) + ":value");
		val.appendChild(doc.createTextNode(value));
		item.appendChild(val);

        getElement().appendChild(item);
        Initializer.initializeUIElements(item);
	}

    private void updateItem(Element item, String label,
                            String value, boolean selected) {

        Element lbl = (Element) item.getFirstChild();
        lbl.getFirstChild().setNodeValue(label);

        Element val = (Element) lbl.getNextSibling();
        val.getFirstChild().setNodeValue(value);

        setItemSelection(item, selected);
    }

    private void setItemSelection(Element item, boolean selected) {
        item.setAttributeNS(NamespaceCtx.XFORMS_NS,
                            xformsPrefix + ":" + SELECTED_ATTRIBUTE,
                            String.valueOf(selected));
    }
}
//end of class

