<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xforms="http://www.w3.org/2002/xforms"
                xmlns:xlink="http://www.w3.org/1999/xlink"
                xmlns:chiba="http://chiba.sourceforge.net/2003/08/xforms"
                exclude-result-prefixes="chiba xforms xlink xsl">

    <xsl:import href="html-standard.xsl" />

    <xsl:output method="html"/>


<xsl:param name="action-path" select="''"/>
<xsl:param name="base-url" select="''"/>
<xsl:param name="form-id" select="'chiba-form'"/>
<xsl:param name="form-name" select="'Chiba XForms Processor'"/>
<xsl:param name="debug-enabled" select="'true'"/>

<xsl:variable name="index" select="descendant::xforms:repeat[@id='repeat-id']" />

<xsl:template match="body">

<html>
    <head>
        <title>Form Designer</title>
        <script language="JavaScript">
            <xsl:comment>
            var selected ;
            function selectRow (tr, position) {
                if (selected != null) {
                    selected.className='default';
                }
                selected = tr;
                selected.className='selected';
                document.forms[0].elements['chiba:head/cursor//repeat-id'].value=position;
                return true;
            }
            </xsl:comment>
        </script>
        <style type="text/css">
            <xsl:comment>
            .default {color:black; background:lightgrey;}
            .selected {color:white; background:blue;}
            </xsl:comment>
        </style>
    </head>
    <body bgcolor="lightgrey" onLoad="javascript:selectRow(document.getElementById({$index/@chiba:index}),{$index/@chiba:index})">
        <form name="{$form-id}" action="{$base-url}/{$action-path}" method="post" enctype="application/x-www-form-urlencoded">
<!--            <xsl:variable name="ind" select="//xforms:repeat/@chiba:index"/>-->
            <input type="hidden" name="chiba:head/cursor//repeat-id" value="{$index/@chiba:index}"/>
            <xsl:apply-templates />
        </form>
    </body>
</html>
</xsl:template>

<xsl:template match="xforms:label[../@id='name-id']"/>
<xsl:template match="xforms:label[../@id='file-name']"/>
<!--<xsl:template match="xforms:input[@id='name']/xforms:label"/>-->

<xsl:template match="xforms:repeat[@id='repeat-id']">

    <table border="1" width="80%" bgcolor="silver" id="repeat-table">
        <xsl:for-each select="xforms:group[@chiba:transient='true']">
            <tr onClick="javascript:selectRow(this, {position()})" class="default" id="{position()}">
                <td>
                    <xsl:variable name="depth" select="xforms:output[1]/xforms:value"/>
                    <xsl:variable name="indent" select="20 * $depth"/>
                    <img src="images/trans.gif" height="10" width="{$indent}"/>
                    <xsl:value-of select="xforms:output[2]/xforms:value"/>
                </td>
                <td>
                    <xsl:apply-templates select="./xforms:trigger"/>
                </td>
            </tr>
        </xsl:for-each>
    </table>

</xsl:template>

<xsl:template match="xforms:group[@id='detail-group']">
    <center>
        <table border="1" width="400">
            <caption><xsl:value-of select="xforms:label"/></caption>
            <tr>
                <td><xsl:value-of select="xforms:input[@id='name']/xforms:label"/></td>
                <td><xsl:apply-templates select="xforms:input[@id='name']"/></td>
            </tr>
            <tr>
                <td><xsl:value-of select="xforms:input[@id='label']/xforms:label"/></td>
                <td><xsl:apply-templates select="xforms:input[@id='label']"/></td>
            </tr>
            <tr>
                <td><xsl:value-of select="xforms:input[@id='hint']/xforms:label"/></td>
                <td><xsl:apply-templates select="xforms:input[@id='hint']"/></td>
            </tr>
            <tr>
                <td><xsl:value-of select="xforms:textarea[@id='help']/xforms:label"/></td>
                <td><xsl:apply-templates select="xforms:textarea[@id='help']"/></td>
            </tr>
            <tr>
                <td><xsl:value-of select="xforms:select1[@id='appearance']/xforms:label"/></td>
                <td><xsl:apply-templates select="xforms:select1[@id='appearance']"/></td>
            </tr>

        </table>
    </center>
<!--    <xsl:apply-templates />-->
</xsl:template>

<xsl:template match="xforms:group[@id='model-items']">
    <center>
        <table border="1" width="400">
            <caption><xsl:value-of select="xforms:label"/></caption>
            <tr>
                <td><xsl:value-of select="xforms:input[@id='required']/xforms:label"/></td>
                <td><xsl:apply-templates select="xforms:input[@id='required']"/></td>
            </tr>

            <tr>
                <td><xsl:value-of select="xforms:input[@id='readonly']/xforms:label"/></td>
                <td><xsl:apply-templates select="xforms:input[@id='readonly']"/></td>
            </tr>
            <tr>
                <td><xsl:value-of select="xforms:input[@id='relevant']/xforms:label"/></td>
                <td><xsl:apply-templates select="xforms:input[@id='relevant']"/></td>
            </tr>
            <tr>
                <td><xsl:value-of select="xforms:input[@id='constraint']/xforms:label"/></td>
                <td><xsl:apply-templates select="xforms:input[@id='constraint']"/></td>
            </tr>
            <tr>
                <td><xsl:value-of select="xforms:input[@id='calculate']/xforms:label"/></td>
                <td><xsl:apply-templates select="xforms:input[@id='calculate']"/></td>
            </tr>

            <tr>
                <td><xsl:value-of select="xforms:select1[@id='type']/xforms:label"/></td>
                <td><xsl:apply-templates select="xforms:select1[@id='type']"/></td>
            </tr>

        </table>
    </center>
<!--    <xsl:apply-templates />-->
</xsl:template>

<xsl:template match="xforms:input">
    <xsl:if test="$debug-enabled='true'">
        <xsl:message>handling input ...</xsl:message>
    </xsl:if>

    <xsl:call-template name="input">
        <xsl:with-param name="name" select="@chiba:name"/>
        <xsl:with-param name="value" select="xforms:value"/>
        <xsl:with-param name="size" select="60"/>
    </xsl:call-template>

    <xsl:apply-templates select="xforms:help"/>
    <xsl:apply-templates select="xforms:alert"/>
</xsl:template>

<xsl:template match="xforms:textarea">
    <xsl:if test="$debug-enabled='true'">
        <xsl:message>handling textarea ...</xsl:message>
    </xsl:if>

    <xsl:call-template name="textarea">
        <xsl:with-param name="name" select="@chiba:name"/>
        <xsl:with-param name="value" select="xforms:value"/>
        <xsl:with-param name="rows" select="3"/>
        <xsl:with-param name="cols" select="60" />
    </xsl:call-template>

    <xsl:apply-templates select="xforms:help"/>
    <xsl:apply-templates select="xforms:alert"/>
</xsl:template>

<xsl:template match="xforms:select1">
    <xsl:if test="$debug-enabled='true'">
        <xsl:message>handling select1 ...</xsl:message>
    </xsl:if>

    <xsl:call-template name="select1">
        <xsl:with-param name="name" select="@chiba:name"/>
        <xsl:with-param name="value" select="xforms:value"/>
        <xsl:with-param name="appearance" select="@xforms:appearance" />
    </xsl:call-template>

    <xsl:apply-templates select="xforms:help"/>
    <xsl:apply-templates select="xforms:alert"/>
</xsl:template>

</xsl:stylesheet>
