package org.chiba.connectors.xmlrpc;

import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.chiba.xml.xforms.exception.XFormsException;
import org.w3c.dom.Document;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.Vector;


public class RPCClient {
	private String URL = null;
	private static final String DEFAULT_URL = "http://localhost:8088/";
	
	private XmlRpcClient xmlrpc = null;

	public RPCClient() throws MalformedURLException {
		this.URL = DEFAULT_URL;
		xmlrpc = new XmlRpcClient (URL);
	};
	
	public RPCClient(String URL) throws MalformedURLException {
		this.URL = URL;
		xmlrpc = new XmlRpcClient (this.URL);
	}
	
	public Document getDocument(String function, Hashtable params) throws XFormsException {
		Vector v = new Vector();
		v.addElement(params);
		
		Hashtable ret = runFunc(function, v);
		
		if (!ret.containsKey("status")) {
			throw new XFormsException("XML-RPC has no status");
		}
		
		String status = (String)ret.get("status");
		
		if (status.equals("error")) {

			if (!ret.containsKey("error")) {
				throw new XFormsException("Cannot find XML-RPC error code");
			}
		
			String s = (String)ret.get("error");
			throw new XFormsException(s);
		}
		
		byte[] docbytes = (byte[])ret.get("doc");
		
		Document doc = null;
		try {
			DocTransformer dt = new DocTransformer(docbytes);
			doc = dt.getDoc();
		} catch (Exception e) {
			throw new XFormsException(e);
		}
		
		return doc;
	}
	
	private Hashtable runFunc(String function, Vector params) {
		Hashtable h = null;
		Object o = null;
		try {
			o = xmlrpc.execute (function, params);
		} catch (XmlRpcException e) {
			h = new Hashtable();
			h.put("status", "error");
			h.put("error", "Cannot execute XML-RPC query: (" + e.getCause() + ":" + e.toString() + ")");
			return h;
		} catch (IOException e) {
			h = new Hashtable();
			h.put("status", "error");
			h.put("error", "IO Exception executing XML-RPC query: " + e.toString());
			return h;
		}
		if (o == null) {
			h = new Hashtable();
			h.put("status", "error");
			h.put("error", "Object is NULL");
		} else {
			h = (Hashtable)o;
		}
		return h;
	}
	

}

