/*
 * Adapter.java
 *
 * Created on 19 de enero de 2004, 16:30
 */

package org.chiba.adapter;

import java.io.IOException;
import java.io.Writer;

/** Interface to build an environment around the Chiba Processor
 * @author emillan
 */
public interface Adapter {
    
    /** Initialize this adapter */    
    public void init();
    
    /** Press the adapter to build the User Interface to the referenced Writer
     * @param out Some writer
     * @throws IOException If an input/output error ocurred
     */    
    public void buildUI(Writer out) throws IOException;
    
    /** Establish a property for the adapter
     * @param key Property key
     * @param value Property value
     */    
    public void setProperty(Object key, Object value);
    
    /** Obtains an adapter property previously set
     * @param key Property key
     * @return Property value or null if the property is not present
     */    
    public Object getProperty(Object key);
    
    /** Release all required resources */    
    public void release();
    
    /** Returns the internal object referenced by 'id'
     * @param id Get the internal object (right now, would be the ChibaBean 
     * instance). With the 'id'
     * parameter, the adapter is able to manage several instances.
     * @return The internal object.
     * If no internal object is present, returns null.
     */    
    public Object getInternal(Object id);
    
    /** Press the adapter to manage the XForms process
     * @param ref An object reference (for example, talking about a servlet environment, the 'ref'
     * parameter would be the servlet instance, the request instance and so on).
     */    
    public void handleProcess(Object ref);
    
}
