/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: XASourceResolver.java,v $
 * Version:       $Name:  $ $Revision: 1.2 $
 * Last Modified: $Date: 2004/06/07 15:17:35 $
 *****************************************************************************/
package org.ten60.netkernel.cocoon;

import com.ten60.netkernel.urii.IURRepresentation;
import com.ten60.netkernel.urii.aspect.IAspectReadableBinaryStream;
import com.ten60.netkernel.util.NetKernelException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Map;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.excalibur.source.Source;
import org.ten60.netkernel.xml.xahelper.XAHelper;
import org.xml.sax.SAXException;
import java.util.List;
/**
 *
 * @author  tab
 */
class XASourceResolver implements SourceResolver
{	private XAHelper mHelper;
	private List mUsageDependencies;
	public XASourceResolver(XAHelper aHelper, List aUsageDependencies)
	{	mHelper=aHelper;
		mUsageDependencies = aUsageDependencies;
	}
	
	public org.apache.cocoon.environment.Source resolve(String SystemId) throws ProcessingException, SAXException, IOException
	{	throw new ProcessingException("SourceResolver.resolve() not implemented");
	}
	public Source resolveURI(String aLocation) throws MalformedURLException, IOException
	{	return resolveURI(aLocation,null,null);
	}
	public Source resolveURI(String aLocation, String aBase, Map aParameters) throws MalformedURLException, IOException
	{	URI resource=URI.create(aLocation);
		if(!resource.isAbsolute())
		{	resource=mHelper.getCurrentWorkingURI().resolve(resource);
		}
		try
		{	IURRepresentation rep = mHelper.getResource(resource,IAspectReadableBinaryStream.class);
			if (mUsageDependencies!=null)
			{	mUsageDependencies.add(rep);
			}
			IAspectReadableBinaryStream aspect=(IAspectReadableBinaryStream)rep.getAspect(IAspectReadableBinaryStream.class);
			return new BinaryStreamSource(aspect, rep.getMeta(), resource);
		}
		catch(NetKernelException e)
		{	throw new IOException("Resource "+aLocation+" "+aBase+" could not be accessed");
		}
	}

	public void release(Source aSource)
	{
	}
}	