/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: TransformerAdapter.java,v $
 * Version:       $Name:  $ $Revision: 1.2 $
 * Last Modified: $Date: 2004/06/07 15:17:35 $
 *****************************************************************************/
package org.ten60.netkernel.cocoon;

import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.layer1.representation.*;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.aspect.*;
import com.ten60.netkernel.util.*;

import org.apache.cocoon.*;
import org.apache.cocoon.transformation.*;
import org.apache.cocoon.environment.*;
import org.apache.cocoon.components.*;
import org.apache.avalon.framework.parameters.*;
import org.apache.avalon.framework.configuration.*;
import org.apache.avalon.framework.service.*;
import org.apache.avalon.framework.logger.*;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.excalibur.component.*;

import java.util.*;
import java.util.logging.*;

import java.net.*;
/**
 *
 * @author  tab
 */
public class TransformerAdapter extends XAccessor
{
	private static Map sTypeToClassMap = new HashMap();
	static
	{	sTypeToClassMap.put("TraxTransformer","org.apache.cocoon.transformation.TraxTransformer");
		sTypeToClassMap.put("XIncludeTransformer","org.apache.cocoon.transformation.XIncludeTransformer");
		sTypeToClassMap.put("CIncludeTransformer","org.apache.cocoon.transformation.CIncludeTransformer");
		sTypeToClassMap.put("EncodeURLTransformer","org.apache.cocoon.transformation.EncodeURLTransformer");
		sTypeToClassMap.put("SourceWritingTransformer","org.apache.cocoon.transformation.SourceWritingTransformer");
		sTypeToClassMap.put("JPathTransformer","org.apache.cocoon.transformation.JPathTransformer");
		sTypeToClassMap.put("FilterTransformer","org.apache.cocoon.transformation.FilterTransformer");
		sTypeToClassMap.put("WriteDOMSessionTransformer","org.apache.cocoon.transformation.WriteDOMSessionTransformer");
		sTypeToClassMap.put("ReadDOMSessionTransformer","org.apache.cocoon.transformation.ReadDOMSessionTransformer");
		sTypeToClassMap.put("LogTransformer","org.apache.cocoon.transformation.LogTransformer");
		sTypeToClassMap.put("JXTemplateTransformer","org.apache.cocoon.transformation.JXTemplateTransformer");
		sTypeToClassMap.put("FragmentExtractorTransformer","org.apache.cocoon.transformation.FragmentExtractorTransformer");
		sTypeToClassMap.put("LexicalTransformer","org.apache.cocoon.transformation.LexicalTransformer");
		sTypeToClassMap.put("ParserTransformer","org.apache.cocoon.transformation.ParserTransformer");
		sTypeToClassMap.put("PatternTransformer","org.apache.cocoon.transformation.PatternTransformer");
		sTypeToClassMap.put("SQLTransformer","org.apache.cocoon.transformation.SQLTransformer");
		sTypeToClassMap.put("DeliTransformer","org.apache.cocoon.transformation.DeliTransformer");
		sTypeToClassMap.put("JXFormsTransformer","org.apache.cocoon.transformation.JXFormsTransformer");
		sTypeToClassMap.put("LDAPTransformer","org.apache.cocoon.transformation.LDAPTransformer");
		sTypeToClassMap.put("CopletTransformer","org.apache.cocoon.transformation.CopletTransformer");
		sTypeToClassMap.put("SessionTransformer","org.apache.cocoon.transformation.SessionTransformer");
		sTypeToClassMap.put("SessionPreTransformer","org.apache.cocoon.transformation.SessionPreTransformer");
		sTypeToClassMap.put("SessionPostTransformer","org.apache.cocoon.transformation.SessionPostTransformer");
		sTypeToClassMap.put("DASLTransformer","org.apache.cocoon.transformation.DASLTransformer");
		sTypeToClassMap.put("XMLDBTransformer","org.apache.cocoon.transformation.XMLDBTransformer");
	}
	
	/** Creates a new instance of TransformerAdapter */
	public TransformerAdapter() throws Exception
	{	declareArgument(XAccessor.OPERAND, true, false);
		declareArgument("src", false, false);
		declareArgument(XAccessor.PARAMETER, false, false);
		declareArgument("configuration", false, false);
	}
	
	protected IURRepresentation source(XAHelper aHelper) throws Throwable
	{	String type=aHelper.getType();
		String className=null;
		if (!type.startsWith("cocoon.transformer") || (className=(String)sTypeToClassMap.get(type.substring(19)))==null)
		{	throw new NetKernelException("Unsupported Transformer","The transformer ["+type+"] is unsupported",type);
		}
		Class transformerClass = Class.forName(className);
		AbstractTransformer transformer = (AbstractTransformer)transformerClass.newInstance();
		IAspectSAX resultAspect = new TransformerSAXAspect(transformer,aHelper);
		IURMeta meta = aHelper.getDependencyMeta("text/xml", 64);
		IURRepresentation result = new MonoRepresentationImpl(meta,resultAspect);
		return result;
	}
}