/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: BinaryStreamSource.java,v $
 * Version:       $Name:  $ $Revision: 1.2 $
 * Last Modified: $Date: 2004/06/07 15:17:35 $
 *****************************************************************************/
package org.ten60.netkernel.cocoon;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.aspect.*;
import org.apache.excalibur.source.*;
import org.apache.excalibur.source.impl.validity.*;

import java.io.*;
import java.net.*;
/**
 *	A wrapper around a readable binary stream.
 * I don't think any of the fields other that getInputStream are necessary as all caching/validity is performed by NK
 * @author  tab
 */
public class BinaryStreamSource implements Source
{
	private IAspectReadableBinaryStream mStream;
	private IURMeta mMeta;
	private URI mURI;
	/** Creates a new instance of BinaryStreamSource */
	public BinaryStreamSource(IAspectReadableBinaryStream aStream, IURMeta aMeta, URI aURI)
	{	mStream = aStream;
		mMeta = aMeta;
		mURI = aURI;
	}
	
	public boolean exists()
	{	return true;
	}
	
	public long getContentLength()
	{	return mStream.getContentLength();
	}
	
	public java.io.InputStream getInputStream() throws java.io.IOException, org.apache.excalibur.source.SourceNotFoundException
	{	return mStream.getInputStream();
	}
	
	public long getLastModified()
	{	return 0;
	}
	
	public String getMimeType()
	{	return mMeta.getMimeType();
	}
	
	public String getScheme()
	{	return mURI.getScheme();
	}
	
	public String getURI()
	{	return mURI.toString();
	}
	
	public org.apache.excalibur.source.SourceValidity getValidity()
	{	return new ExpiresValidity(0);
	}
	
	public void refresh()
	{
	}	
}