<?xml version="1.0" encoding="UTF-8" ?>

<!--
    <comment>
		****************
		(C) 2003-2004, 1060 Research Limited. All rights reserved.
		Licensed under the 1060 Blogxter Non-commerical-Use License v1.0 -
		You are permitted to use this software only for non-commercial applications.
		For commercial licenses visit: http://www.1060research.com/license
		1060 is a registered trademark of 1060 Research Ltd.
		**********
		</comment>
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html"/>

	<xsl:param name="param"/>
	
	<xsl:key name="emails" match="row" use="email"/>
	
	<xsl:template match="/results">
        	<html>
					<p>
					A new comment has been made to your blog entry <b><xsl:value-of select="row[1]/title"/></b> in blog 
					<b><xsl:value-of select="row[1]/name"/></b>
					</p>
					<p>
					<xsl:value-of select="row[1]/summary"/>
					</p>
					<div style="background-color: silver">
					<h2>Comment</h2>
					<table>
					<tr>
						<td>Title</td><td><h3><xsl:value-of select="$param/nvp/title"/></h3></td>
					</tr>
					<tr>
						<td>Name</td>
						<td>
							<a>
								<xsl:attribute name="href">mailto:<xsl:value-of select="$param/nvp/email"/></xsl:attribute>
								<xsl:value-of select="$param/nvp/name"/>
							</a>
						</td>
					</tr>
					<tr>
						<td>Web</td>
						<td>
							<a>
								<xsl:attribute name="href"><xsl:value-of select="$param/nvp/web"/></xsl:attribute>
								<xsl:value-of select="$param/nvp/web"/>
							</a>
						</td>
					</tr>
					</table>
					<xsl:copy-of select="$param/nvp/comment/div"/>
					<a>
						<xsl:attribute name="href"><xsl:value-of select="row[1]/hostname"/>blogxter/myblog/startedit?blogid=<xsl:value-of select="row[1]/blogid"/></xsl:attribute>
						edit blog
					</a>
					</div>
				</html>
    </xsl:template>

</xsl:stylesheet>