/******************************************************************************
  (c) Copyright 2003,2004, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: BlogxterDataAccessor.java,v $
  Version:       $Name:  $ $Revision: 1.2 $
  Last Modified: $Date: 2004/02/10 18:16:42 $
 *****************************************************************************/

package org.ten60.blogxter.data;

import org.ten60.netkernel.layer1.accessor.AccessorImpl;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urrequest.*;
import com.ten60.netkernel.module.*;
import com.ten60.netkernel.container.*;
import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.representation.*;
import com.ten60.netkernel.urii.aspect.NetKernelExceptionAspect;
import com.ten60.netkernel.util.*;

import org.ten60.netkernel.xml.representation.*;

import java.net.*;
import java.io.*;
import org.w3c.dom.*;

/**
 *
 * @author  pjr
 */
public class BlogxterDataAccessor extends AccessorImpl
{
	private URI basepath;
	private static URI blogRoot=URI.create("blog:/");
	
	/** Creates a new instance of BlogxterDataAccessor */
	public BlogxterDataAccessor()
	{	super(new DataAccessorMeta(4,URRequest.RQT_SOURCE|URRequest.RQT_SINK|URRequest.RQT_NEW,true));
	}
	
	public void init(URIdentifier aURI, ModuleDefinition aModule, Container aContainer) throws NetKernelException
	{	super.init(aURI,aModule,aContainer);
		URL config=aModule.getResource("/etc/ConfigBlogxter.xml");
		try
		{	if (config==null)
			{	throw new Exception("configuration not found");
			}
			Reader r = new InputStreamReader(config.openStream());
			Document d = XMLUtils.getInstance().parse(r);
			XMLReadable readable = new XMLReadable(d);
			String path=readable.getText("/config/blogpath");
			URI scratch=URI.create(aModule.getScratchDirURI());
			basepath=scratch.resolve(path);
			System.err.println("Blogxter basepath: "+basepath.toString());
		}
		catch(Throwable e)
		{	NetKernelException nke=new NetKernelException("Exception initializing Blogxter Data Accessor");
			nke.addCause(e);
			throw nke;
		}
	}
	
	public void requestAsync(com.ten60.netkernel.urrequest.URRequest aRequest)
	{	IURRepresentation result=null;
		boolean error=false;
		try
		{	switch(aRequest.getType())
			{	case URRequest.RQT_SOURCE:
				{
					URI bloguri=URI.create(aRequest.getURI().toString());
					URI fileuri=translateURI(bloguri);
					URRequest req=new URRequest(new URIdentifier(fileuri.toString()), this,	aRequest.getSession(), aRequest.getContext(), URRequest.RQT_SOURCE, aRequest.getCWU(), aRequest, IXAspect.class);
					result=getScheduler().requestSynch(req).getResource();
				}
				break;
				case URRequest.RQT_SINK:
				{
					URI bloguri=URI.create(aRequest.getURI().toString());
					URI fileuri=translateURI(bloguri);
					URRequest req=new URRequest(new URIdentifier(fileuri.toString()), this,	aRequest.getSession(), aRequest.getContext(), URRequest.RQT_SINK, aRequest.getCWU(), aRequest, IXAspect.class);
					req.addArg(URRequest.URI_SYSTEM,aRequest.getArg(URRequest.URI_SYSTEM));
					result=getScheduler().requestSynch(req).getResource();
				}
				break;
				case URRequest.RQT_DELETE:
				{
					URI bloguri=URI.create(aRequest.getURI().toString());
					URI fileuri=translateURI(bloguri);
					URRequest req=new URRequest(new URIdentifier(fileuri.toString()), this,	aRequest.getSession(), aRequest.getContext(), URRequest.RQT_DELETE, aRequest.getCWU(), aRequest, IXAspect.class);
					result=getScheduler().requestSynch(req).getResource();
				}
				case URRequest.RQT_NEW:
					result=blognew(aRequest);
				break;
				
				default:
				break;
			}
			if(result==null) throw new Exception("Unexpected null result");
		}
		catch(Throwable t)
		{	NetKernelException nke=new NetKernelException("Exception blogging "+aRequest.getURI().toString());
			nke.addCause(t);
			result= NetKernelExceptionAspect.create(nke);
			error=true;
		}
		if(error)
		{	getScheduler().receiveAsyncException(new URResult(aRequest, result));
		}
		getScheduler().receiveAsyncResult(new URResult(aRequest, result));
		
	}
	
	private IURRepresentation blognew(URRequest aRequest) throws Throwable
	{	URI fileuri=null;
		String absoluteBlogUri=null;
		URRequest req=new URRequest(new URIdentifier("active:guid"), this,	aRequest.getSession(), aRequest.getContext(), URRequest.RQT_SOURCE, aRequest.getCWU(), aRequest, IXAspect.class);
		while(absoluteBlogUri==null)
		{	IXAspect xres=(IXAspect)getScheduler().requestSynch(req).getResource().getAspect(IXAspect.class);
			String guid=xres.getXDA().getText("/guid", true);
			String relativeBlogUri="blog_"+guid+".xml";
			fileuri=basepath.resolve(relativeBlogUri);
			File f=new File(fileuri);
			if(!f.exists()) absoluteBlogUri="blog:/"+relativeBlogUri;
		}
		return URIAspect.create(new DependencyMeta("text/uri", 4, 0), URI.create(absoluteBlogUri));
	}
	
	private URI translateURI(URI aBlogUri)
	{	URI relativeBlogUri=blogRoot.relativize(aBlogUri);
		return basepath.resolve(relativeBlogUri);
	}
	
}
