/******************************************************************************
  (c) Copyright 2003,2004, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: BlogxterSpellreplaceAccessor.java,v $
  Version:       $Name:  $ $Revision: 1.2 $
  Last Modified: $Date: 2004/02/10 18:16:42 $
 *****************************************************************************/

package org.ten60.blogxter.active;

import org.ten60.rdbms.accessor.*;
import org.ten60.rdbms.util.*;

import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.util.*;

import java.text.*;
import java.util.*;
import java.util.regex.*;
import java.io.*;

/**
 *	Database operations for blogxter
 * @author  pjr
 */
public class BlogxterSpellreplaceAccessor extends XAccessor
{
	/** Creates a new instance of TimeStampAccessor */
	public BlogxterSpellreplaceAccessor()
	{	declareArgument(OPERAND, true,false);
		declareArgument(OPERATOR, true,false);
	}
	
	protected com.ten60.netkernel.urii.IURRepresentation source(XAHelper aHelper) throws Throwable
	{	IXDAReadOnlyIterator it=aHelper.getOperator().getXDA().readOnlyIterator("/nvp/replace");
		HashMap map=new HashMap();
		while(it.hasNext())
		{	it.next();
			
			String word=it.eval("substring-before(., ',')").getStringValue();
			String replace=it.eval("substring-after(., ',')").getStringValue();
			map.put(word,replace);
		}
		DOMXDA xda=new DOMXDA(aHelper.getOperand().getReadOnlyDocument());
		String entry=xda.getText("/blog/item/entry", false);
		String title=xda.getText("/blog/item/title", false);
		Set keys=map.keySet();
		Iterator i=keys.iterator();
		while(i.hasNext())
		{	String word=(String)i.next();
			String sp=(String)map.get(word);
			Pattern p=Pattern.compile(word, Pattern.DOTALL);
			Matcher m=p.matcher(entry);
			entry=m.replaceAll(sp);
			m=p.matcher(title);
			title=m.replaceAll(sp);
		}
		xda.setText("/blog/item/entry", entry);
		xda.setText("/blog/item/title", title);
		return DOMXDAAspect.create(aHelper.getDependencyMeta("text/xml", 8), xda);
	}	

	
}
