<?xml version="1.0" encoding="UTF-8" ?>

<!--
   <comment>
		****************
		(C) 2003-2004, 1060 Research Limited. All rights reserved.
		Licensed under the 1060 Public License v1.0 - You may modifiy and
		use this software in any manner provided that any derivative work
		is licensed in complience with the terms of the 1060 Public License.
		For commercial licenses visit: http://www.1060research.com/license
		1060 is a registered trademark of 1060 Research Ltd.
		**********
		</comment>
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>
	
	<xsl:param name="param"/>

    <xsl:template match="/results">
		<sql>
			SELECT users.email, blogs.name, entries.title, entries.summary, blogs.id as blogid, blogs.hostname FROM users, blogs, affiliations, groups, entries WHERE
				(	entries.publicid='<xsl:value-of select="$param/nvp/publicid/text()"/>' AND
					entries.blogid=blogs.id AND
					affiliations.blogid=blogs.id AND
					affiliations.userid=users.id AND
					affiliations.groupid=groups.id AND
					<xsl:choose>
						<xsl:when test="row/value = 1">
						groups.name='author'
						</xsl:when>
						<xsl:when test="row/value = 2">
						( groups.name='editor' OR groups.name='author' )
						</xsl:when>
					</xsl:choose>
				 );
		
		</sql>
    </xsl:template>

</xsl:stylesheet> 
