/******************************************************************************
 * (c) Copyright 2002,2004, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: SOAPServiceMapDocumentToSOAPServerConfigTransreptor.java,v $
 * Version:       $Name:  $ $Revision: 1.12 $
 * Last Modified: $Date: 2006/07/04 11:03:22 $
 *****************************************************************************/
package org.ten60.netkernel.ws.soap.server;

import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.*;
import org.ten60.netkernel.layer1.transrepresentation.*;
import org.ten60.netkernel.layer1.representation.*;
//import org.ten60.netkernel.layer1.meta.*;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.urii.representation.ITransrepresentor;

import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.transrepresentation.*;
import com.ten60.netkernel.urii.aspect.*;

import org.ten60.netkernel.ws.soap.aspect.*;

import java.net.*;

/**
 * Transrepresent a SOAPServiceMap  XML Config Document to a SOAPServerConfig
 * @author  pjr
 */
public class SOAPServiceMapDocumentToSOAPServerConfigTransreptor extends NKFTransreptorImpl
{
	
	public boolean supports(IURRepresentation aFrom, Class aTo)
	{	return ( (aFrom.hasAspect(IXAspect.class) || aFrom.hasAspect(IAspectBinaryStream.class)) && ( aTo.isAssignableFrom(IAspectSOAPServerConfig.class)) );
	}
	
	protected void transrepresent(INKFConvenienceHelper context) throws Exception
	{	IXAspect doc=(IXAspect)context.sourceAspect(INKFRequestReadOnly.URI_SYSTEM, IXAspect.class);
		SOAPServerConfig result=new SOAPServerConfig();
		//Algorithm to determine the baseURI of the SOAP server...
		String baseURI=null;
		//First look in the service map
		if(doc.getXDA().isTrue("/SOAPServiceMap/baseURI"))
		{	baseURI=doc.getXDA().getText("/SOAPServiceMap/baseURI",true);
		}
		else
		{	//Then try up the superstack for /etc/UserSOAPConfig.xml
			try
			{	IXAspect portconfig=(IXAspect)context.sourceAspect("ffcpl:/etc/UserSOAPConfig.xml", IXAspect.class);
				baseURI=portconfig.getXDA().getText("/SOAPConfig/baseURI",true);
			}
			catch(Exception e)
			{	/*Ignore*/
			}
		}
		if(baseURI==null)
		{	//Finally set the base path to the server hostname
			baseURI="http://"+java.net.InetAddress.getLocalHost().getCanonicalHostName();
		}
		result.setBaseURI(baseURI);
		
		try
		{	//add services
			IXDAReadOnlyIterator i=doc.getXDA().readOnlyIterator("/SOAPServiceMap/service");
			while(i.hasNext())
			{	i.next();
				String name=null;
				String endpoint=null;
				if(i.isTrue("name")) name=i.getText("name", true);
				else throw new Exception ("name not specified in SOAPServiceMap service");
				if(i.isTrue("endpoint")) endpoint=i.getText("endpoint", true);
				else throw new Exception ("endpoint not specified in SOAPServiceMap service");				
				result.addService(endpoint, name);
				if(i.isTrue("wsdl")) result.setWSDL(endpoint, i.getText("wsdl", true));
			}
			//add ports
			i=doc.getXDA().readOnlyIterator("/SOAPServiceMap/port");
			while(i.hasNext())
			{	i.next();
				SOAPServicePort port = new SOAPServicePort();
				if(i.isTrue("type"))
				{   String type= i.getText("type",true);
				    if(type.toLowerCase().equals("rpc")) port.setDocMode(false);
				}
				if(i.isTrue("name")) port.setName(i.getText("name", true));
				else throw new Exception ("name not specified in SOAPServiceMap port");
				if(i.isTrue("endpoint")) port.setEndpoint(i.getText("endpoint", true));
				else throw new Exception ("endpoint not specified in SOAPServiceMap port");
				if(i.isTrue("int")) port.setInternal(i.getText("int", true));
				else throw new Exception ("int not specified - must provide internal URI");
				if(i.isTrue("action")) port.setAction(i.getText("action", true));
				if(i.isTrue("messageIn"))
				{   String schema=null;
				    if(i.isTrue("messageIn/schema")) schema=i.getText("messageIn/schema", true);
				    String element=i.getText("messageIn/element", true);
				    MessageStruct ms=new MessageStruct(schema, element);
				    port.setMessageIn(ms);
				}
				if(i.isTrue("messageOut"))
				{   String schema=null;
				    if(i.isTrue("messageOut/schema")) schema=i.getText("messageOut/schema", true);
				    String element=i.getText("messageOut/element", true);
				    MessageStruct ms=new MessageStruct(schema, element);
				    port.setMessageOut(ms);
				}
				if(i.isTrue("class")) port.setClassname(i.getText("class", true));
				if(i.isTrue("doc")) port.setDoc(i.getText("doc", true));
				result.addPort(port);
			}
			INKFResponse resp=context.createResponseFrom(new SOAPServerConfigAspect(result));
			resp.setMimeType("application/soap:serverconfig");
		}
		catch(Exception e)
		{	NetKernelException nke=new NetKernelException("Failure in SOAPServiceMap Configuration Transreptor");
			nke.addCause(e);
			throw nke;
		}
	}
	
}