/******************************************************************************
 * (c) Copyright 2002,2004, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: SOAPClient.java,v $
 * Version:       $Name:  $ $Revision: 1.6 $
 * Last Modified: $Date: 2004/08/04 16:56:50 $
 *****************************************************************************/
package org.ten60.netkernel.ws.soap.client;

import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.layer1.util.*;
import org.ten60.netkernel.layer1.representation.*;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urrequest.*;
import com.ten60.netkernel.urii.meta.MetaImpl;
import java.net.*;
import java.io.*;

/**
 * Universal SOAPClient - uses a Bindings Configuration to direct SOAP requests
 * to a specific SOAP Binding Accessor.
 * @author  pjr
 */
public class SOAPClient extends XAccessor{
    
   private static final String ARG_ENDPOINT="endpoint";
   private static final String ARG_MESSAGE="message";
   private static final String ARG_ACTION="action";
   private static final String ARG_CONFIG="config";
   private static final String CONFIG_URI="ffcpl:/etc/ConfigSOAPClientBindings.xml";
    
    /** Creates a new instance of SOAPClient */
    public SOAPClient()
    {	declareArgument(ARG_ENDPOINT, true, true);
	declareArgument(ARG_MESSAGE, true, false);
	declareArgument(ARG_ACTION, false, true);
	declareArgument(ARG_CONFIG, false, true);
	declareThreadSafe();
    }
    
    protected com.ten60.netkernel.urii.IURRepresentation source(XAHelper aHelper) throws Exception
    {	/*Find Configuration and locate the Accessor for the SOAP binding*/
	URI configURI=aHelper.getURI(ARG_CONFIG);
	if(configURI==null) configURI=URI.create(CONFIG_URI);
	IAspectSOAPClientBindings cbs=(IAspectSOAPClientBindings)aHelper.getResource(configURI, IAspectSOAPClientBindings.class).getAspect(IAspectSOAPClientBindings.class);
	String accessor=cbs.getAccessorURIMatch(aHelper.getURI(ARG_ENDPOINT).toString());
	
	/*Build the Accessor Binding request*/
	CompoundURIdentifier curi=new CompoundURIdentifier(new URIdentifier(accessor));
	XAHelperExtra extra=(XAHelperExtra)aHelper;
	CompoundURIdentifier reqURI=new CompoundURIdentifier(extra.getRequest().getURI());
	curi.addArg(ARG_ENDPOINT, reqURI.get(ARG_ENDPOINT));
	if(reqURI.get(ARG_ACTION)!=null) curi.addArg(ARG_ACTION, reqURI.get(ARG_ACTION));
	URIdentifier messageURI=URIdentifier.getUnique("literal:param");
	curi.addArg(ARG_MESSAGE, messageURI.toString());
	URRequest req=new URRequest(
		curi.toURI(),
		null,
		extra.getRequest().getSession(),
		this.getModule(),
		URRequest.RQT_SOURCE,
		null,
		extra.getRequest(),
		IURAspect.class
	    );
	req.addArg(messageURI, aHelper.getResource(aHelper.getURI(ARG_MESSAGE), IURAspect.class));
	
	/*Issue request*/
	URResult result=getScheduler().requestSynch(req);
	return result.getResource();
    }
 
}
