/******************************************************************************
 * (c) Copyright 2002,2004, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: wsProcessSOAPMessagePart.java,v $
 * Version:       $Name:  $ $Revision: 1.11 $
 * Last Modified: $Date: 2004/08/04 16:56:50 $
 *****************************************************************************/

package org.ten60.netkernel.ws.soap.accessor;

import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.util.*;
import org.ten60.netkernel.layer1.representation.*;
import com.ten60.netkernel.urii.IURAspect;
import com.ten60.netkernel.urii.IURRepresentation;
import org.ten60.netkernel.ws.soap.util.*;
import java.net.*;
import java.util.*;
import org.w3c.dom.*;
import java.io.*;


/**
 * Test a SOAP message to see if contains a Fault. Returns a BooleanAspect.
 * @author  pjr
 */
public class wsProcessSOAPMessagePart extends XAccessor {
    
    private static final String ADD_HEADER="wsSOAPAddHeader";
    private static final String DELETE_HEADER="wsSOAPDeleteHeader";
    private static final String ADD_BODY="wsSOAPAddBody";
    private static final String DELETE_BODY="wsSOAPDeleteBody";
    private static final String GET_HEADER="wsSOAPGetHeader";
    private static final String GET_BODY="wsSOAPGetBody";
    
    private static final int ADD_HEADER_MODE=1;
    private static final int DELETE_HEADER_MODE=2;
    private static final int ADD_BODY_MODE=3;
    private static final int DELETE_BODY_MODE=4;
    private static final int GET_HEADER_MODE=5;
    private static final int GET_BODY_MODE=6;
    
    private static HashMap mMap=new HashMap(6);
    
    {
	mMap.put(ADD_HEADER, new Integer(ADD_HEADER_MODE));
	mMap.put(DELETE_HEADER, new Integer(DELETE_HEADER_MODE));
	mMap.put(ADD_BODY, new Integer(ADD_BODY_MODE));
	mMap.put(DELETE_BODY, new Integer(DELETE_BODY_MODE));
	mMap.put(GET_HEADER, new Integer(GET_HEADER_MODE));
	mMap.put(GET_BODY, new Integer(GET_BODY_MODE));
    }
    
    /** Creates a new instance of wsAddSOAPMessage */
    public wsProcessSOAPMessagePart()
    {	declareArgument(SOAPEnv.ARG_MESSAGE, true, false);
	declareArgument("header", false, false);
	declareArgument("role", false, false);
	declareArgument("actor",false, false);
	declareArgument("mustUnderstand", false, false);
	declareArgument("namespace",false, false);
	declareArgument("body", false, false);
	declareThreadSafe();
    }
    
    protected com.ten60.netkernel.urii.IURRepresentation source(XAHelper aHelper) throws Exception
    {	
	IURRepresentation result=null;
	IXAspect mxa=(IXAspect)aHelper.getResource(aHelper.getURI(SOAPEnv.ARG_MESSAGE), IXAspect.class).getAspect(IXAspect.class);
	DOMXDA message=new DOMXDA(mxa.getReadOnlyDocument(), true);
	String soapNS=message.getDocument().getDocumentElement().getNamespaceURI();
	boolean SOAP11=soapNS.equals(SOAPEnv.SOAP_1_1_NAMESPACE);
	String envPrefix=message.getPrefix(soapNS);
	
	Object key=aHelper.getType();
	Integer mode=(Integer)mMap.get(key);
	if(mode==null) throw new Exception("Unsupported accessor type");
	switch(mode.intValue())
	{
	   case ADD_HEADER_MODE:
	   {	if(!argExists(aHelper,"header")) throw new Exception("header argument not supplied");
		Document headerDOM=aHelper.getXResource(aHelper.getURI("header")).getReadOnlyDocument();
		String namespaceName=headerDOM.getDocumentElement().getNamespaceURI();
		if(namespaceName==null) throw new Exception("SOAP header part must have a namespace");
		String localName=headerDOM.getDocumentElement().getLocalName();
		String prefixName=headerDOM.getDocumentElement().getPrefix();
		String fullName= prefixName!=null ? prefixName+":"+localName : localName;
		DOMXDA header=new DOMXDA(headerDOM);
		if(SOAP11)
		{   if(!message.isTrue(Utils.replacePrefix("/$1:Envelope/$1:Header", envPrefix)))
		    {   DOMXDA temp=new DOMXDA(XMLUtils.getInstance().parse(new StringReader("<"+envPrefix+":Header xmlns:"+envPrefix+"=\""+SOAPEnv.SOAP_1_1_NAMESPACE+"\" />")),false);
			message.insertBefore(temp,"/", Utils.replacePrefix("/$1:Envelope/$1:Body", envPrefix));			
		    }
		    message.append(header,"/", "/"+envPrefix+":Envelope/"+envPrefix+":Header");
		    if(argExists(aHelper,"actor"))
		    {	URI actor=aHelper.getURI("actor");
			message.appendPath(Utils.replacePrefix("/$1:Envelope/$1:Header/", envPrefix)+fullName,"@"+envPrefix+":actor",actor.toString());
		    }
		}
		else
		{   if(!message.isTrue(Utils.replacePrefix("/$1:Envelope/$1:Header", envPrefix)))
		    {   DOMXDA temp=new DOMXDA(XMLUtils.getInstance().parse(new StringReader("<"+envPrefix+":Header xmlns:"+envPrefix+"=\""+SOAPEnv.SOAP_1_2_NAMESPACE+"\" />")),false);
			message.insertBefore(temp,"/", Utils.replacePrefix("/$1:Envelope/$1:Body", envPrefix));			
		    }
		    message.append(header,"/", "/"+envPrefix+":Envelope/"+envPrefix+":Header");
		    if(argExists(aHelper,"role"))
		    {	URI role=aHelper.getURI("role");
			message.appendPath(Utils.replacePrefix("/$1:Envelope/$1:Header/", envPrefix)+fullName,"@"+envPrefix+":role",role.toString());
		    }
		    
		}
		if(argExists(aHelper,"mustUnderstand")) message.appendPath(Utils.replacePrefix("/$1:Envelope/$1:Header/", envPrefix)+fullName,"@"+envPrefix+":mustUnderstand", SOAP11 ? "1" : "true");
		break;
	   }
	   case DELETE_HEADER_MODE:
	   {	if(!argExists(aHelper,"header")) throw new Exception("header argument not supplied");
		String namespace=null;
		if(argExists(aHelper,"namespace")) 
		{   namespace=aHelper.getURI("namespace").toString();
		}
		NodeList nl=message.getNodeList(Utils.replacePrefix("/$1:Envelope/$1:Header",envPrefix));
		Node n=message.getSingleNode(nl);
		String name=aHelper.getXResource(aHelper.getURI("header")).getXDA().eval("name(/*)").getStringValue();
		n=getChildNodeMatching(n, name, namespace);
		if(n==null) throw new Exception("Header entry not found");
		n.getParentNode().removeChild(n);
		break;
	   }
	   case ADD_BODY_MODE:
	   {	if(!argExists(aHelper,"body")) throw new Exception("body argument not supplied");
		Document bodyDOM=aHelper.getXResource(aHelper.getURI("body")).getReadOnlyDocument();
		String namespaceName=bodyDOM.getDocumentElement().getNamespaceURI();
		if(namespaceName==null && SOAP11) throw new Exception("SOAP 1.1 body part must have a namespace");
		String localName=bodyDOM.getDocumentElement().getLocalName();
		String prefixName=bodyDOM.getDocumentElement().getPrefix();
		String fullName= prefixName!=null ? prefixName+":"+localName : localName;
		DOMXDA body=new DOMXDA(bodyDOM);
		if(!message.isTrue(Utils.replacePrefix("/$1:Envelope/$1:Body", envPrefix)))
		{
		    if(SOAP11)
		    {   DOMXDA temp=new DOMXDA(XMLUtils.getInstance().parse(new StringReader("<"+envPrefix+":Body xmlns:"+envPrefix+"=\""+SOAPEnv.SOAP_1_1_NAMESPACE+"\" />")),false);
			message.append(temp,"/", Utils.replacePrefix("/$1:Envelope", envPrefix));
		    }
		    else
		    {   DOMXDA temp=new DOMXDA(XMLUtils.getInstance().parse(new StringReader("<"+envPrefix+":Body xmlns:"+envPrefix+"=\""+SOAPEnv.SOAP_1_2_NAMESPACE+"\" />")),false);
			message.append(temp,"/", Utils.replacePrefix("/$1:Envelope", envPrefix));
		    }
		}
		message.append(body,"/", "/"+envPrefix+":Envelope/"+envPrefix+":Body");
		break;
	   }
	   case DELETE_BODY_MODE:
	   {	if(!argExists(aHelper,"body")) throw new Exception("body argument not supplied");
		String namespace=null;
		if(argExists(aHelper,"namespace")) 
		{   namespace=aHelper.getURI("namespace").toString();
		}
		NodeList nl=message.getNodeList(Utils.replacePrefix("/$1:Envelope/$1:Body",envPrefix));
		Node n=message.getSingleNode(nl);
		String name=aHelper.getXResource(aHelper.getURI("body")).getXDA().eval("name(/*)").getStringValue();
		n=getChildNodeMatching(n, name, namespace);
		if(n==null) throw new Exception("Body entry not found");
		n.getParentNode().removeChild(n);
		break;
	   }
	    case GET_HEADER_MODE:
	    {	if(!argExists(aHelper,"header")) throw new Exception("header argument not supplied");
		String namespace=null;
		if(argExists(aHelper,"namespace")) 
		{   namespace=aHelper.getURI("namespace").toString();
		}
		NodeList nl=message.getNodeList(Utils.replacePrefix("/$1:Envelope/$1:Header",envPrefix));
		Node n=message.getSingleNode(nl);
		String name=aHelper.getXResource(aHelper.getURI("header")).getXDA().eval("name(/*)").getStringValue();
		n=getChildNodeMatching(n, name, namespace);
		if(n==null) throw new Exception("Header entry not found");
		message=new DOMXDA(message.getFragment(n),true);
		break;
	    }
	    case GET_BODY_MODE:
	    {	if(!argExists(aHelper,"body")) throw new Exception("body argument not supplied");
		String namespace=null;
		if(argExists(aHelper,"namespace")) 
		{   namespace=aHelper.getURI("namespace").toString();
		}
		NodeList nl=message.getNodeList(Utils.replacePrefix("/$1:Envelope/$1:Body",envPrefix));
		Node n=message.getSingleNode(nl);
		String name=aHelper.getXResource(aHelper.getURI("body")).getXDA().eval("name(/*)").getStringValue();
		n=getChildNodeMatching(n, name, namespace);
		if(n==null) throw new Exception("Body entry not found");
		message=new DOMXDA(message.getFragment(n),true);
		break;
	    }
	}
	result=DOMXDAAspect.create(aHelper.getDependencyMeta("text/xml",8), message);
	return result;
    }
    
    private Node getChildNodeMatching(Node aParent, String aLocalName, String aNamespaceName)
    {	Node n=null;
	NodeList nl=aParent.getChildNodes();
	for(int i=0; i<nl.getLength(); i++)
	{   if(nl.item(i).getNodeType()==Node.ELEMENT_NODE)
	    {	Node m=nl.item(i);
		if(m.getLocalName().equals(aLocalName))
		{   if(aNamespaceName==null || aNamespaceName.equals(m.getNamespaceURI()))
		    {	n=m;
			break;
		    }
		}
	    }
	}
	return n;
    }
    
    private boolean argExists(XAHelper aHelper, String aArgument) throws Exception
    {	return aHelper.getURI(aArgument)!=null;
    }
    
}