/******************************************************************************
  (c) Copyright 2002-2005, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: RDQLAccessor.java,v $
  Version:       $Name:  $ $Revision: 1.4 $
  Last Modified: $Date: 2005/08/16 08:21:24 $
 *****************************************************************************/

package org.ten60.netkernel.rdf.jena.accessor.rdql;

import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.*;


import com.hp.hpl.jena.rdf.model.*;
import com.hp.hpl.jena.rdql.*;
import org.ten60.netkernel.rdf.jena.representation.*;

import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.util.*;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.aspect.*;
import com.ten60.netkernel.util.NetKernelException;

import java.util.*;
/**
 *
 * @author  pjr
 */
public class RDQLAccessor extends NKFAccessorImpl
{
	/** Creates a new instance of ResourceOperationsAccessor */
	public RDQLAccessor()
	{	super(2, true, INKFRequestReadOnly.RQT_SOURCE);
	}
	
	public void processRequest(INKFConvenienceHelper context) throws Exception
	{	IAspectJenaModel jma=(IAspectJenaModel)context.sourceAspect("this:param:operand", IAspectJenaModel.class);
		Model m=jma.getModelReadOnly();
		IAspectJenaQuery jqa=(IAspectJenaQuery)context.sourceAspect("this:param:operator", IAspectJenaQuery.class);
		boolean modelflag=context.getThisRequest().argumentExists("model");
		Query q=jqa.getQuery();
		IURAspect ra=null;
		synchronized(q)
		{	ModelLock ml=m.getModelLock();
			ml.enterCriticalSection(ml.READ);
			try
			{	q.setSource(m);
				QueryEngine qe=new QueryEngine(jqa.getQuery());
				qe.exec();
				QueryResults qr=qe.exec();
				if(modelflag)
				{	QueryResultsFormatter qrf=new QueryResultsFormatter(qr);
					Model result=qrf.toModel();
					ra=new JenaModelAspect(result);
				}
				else
				{	ra=new StringAspect(formatResults(qr));
				}
			}
			finally
			{	ml.leaveCriticalSection();				
			}
		}
		INKFResponse resp=context.createResponseFrom(ra);
		resp.setCacheable();
		resp.setCreationCost(16);
		context.setResponse(resp);
	}
	
	/**Format the results as an XML results set - NB no validity checking is performed on the XML*/
	private String formatResults(QueryResults qr)
	{	StringBuffer sb=new StringBuffer(2048);
		sb.append("<results>");
		while(qr.hasNext())
		{	sb.append("<row>");
				ResultBinding res=(ResultBinding)qr.next();
				Iterator it=res.names();
				while(it.hasNext())
				{	String name=(String)it.next();
					sb.append("<"+name+">");
					RDFNode n=(RDFNode)res.get(name);
					sb.append(n.toString());
					sb.append("</"+name+">");
				}
			sb.append("</row>");
		}
		sb.append("</results>");
		return sb.toString();
	}
}
