/******************************************************************************
  (c) Copyright 2002-2005, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: SelectFromModelAccessor.java,v $
  Version:       $Name:  $ $Revision: 1.3 $
  Last Modified: $Date: 2005/07/22 15:12:28 $
 *****************************************************************************/

package org.ten60.netkernel.rdf.jena.accessor;

import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.*;

import com.hp.hpl.jena.rdf.model.*;
import org.ten60.netkernel.rdf.jena.representation.*;

import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.util.*;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.util.NetKernelException;

import java.util.*;
/**
 *
 * @author  pjr
 */
public class SelectFromModelAccessor extends NKFAccessorImpl
{
	/** Creates a new instance of ResourceOperationsAccessor */
	public SelectFromModelAccessor()
	{	super(2, true, INKFRequestReadOnly.RQT_SOURCE);
	}
	
	public void processRequest(INKFConvenienceHelper context) throws Exception
	{	Model m=null;
		IAspectJenaModel jma=null;
		jma=(IAspectJenaModel)context.sourceAspect("this:param:operand", IAspectJenaModel.class);
		m=jma.getModelReadOnly();
		Model m2=ModelFactory.createDefaultModel();
		//Do Select Statements
		IXAspect xa=(IXAspect)context.sourceAspect("this:param:operator",IXAspect.class);
		IXDAReadOnly x=xa.getXDA();
		IXDAReadOnlyIterator roi=x.readOnlyIterator("/jRDFSelectFromModel/*");
		ModelLock ml=m.getModelLock();
		ml.enterCriticalSection(ml.READ);
		try
		{	while(roi.hasNext())
			{	roi.next();
				if(roi.isTrue("name()='selector'"))	
				{	String resource=null;
					String propertyNS=null;
					String propertyName=null;
					String value=null;
					if(roi.isTrue("resource"))
					{	resource=roi.getText("resource",true);
					}
					if(roi.isTrue("property"))
					{	propertyNS=roi.getText("property/namespace", true);
						propertyName=roi.getText("property/name", true);
					}
					if(roi.isTrue("value"))
					{	value=roi.getText("value", true);
					}
					Resource r=null;
					Property p=null;
					Object v=null;
					if(resource!=null)
					{	r=m.createResource(resource);					
					}
					if(propertyNS!=null && propertyName!=null)
					{	p=m.createProperty(propertyNS, propertyName);
					}
					SimpleSelector s=null;
					if(value!=null)
					{	if(roi.isTrue("value/@type"))
						{	String type=roi.getText("value/@type", true);
							if(type.equals("xs:int"))
							{	s=new SimpleSelector(r,p,Integer.parseInt(value));
							}
							else if(type.equals("xs:string"))
							{	s=new SimpleSelector(r,p,value);
							}
						}
						else
						{	s=new SimpleSelector(r,p, m.createResource(value));
						}
					}
					else
					{	s=new SimpleSelector(r,p,value);					
					}
					m2=m2.union(m.query(s));
				}
			}
		}
		finally
		{	ml.leaveCriticalSection();		
		}
		jma=new JenaModelAspect(m2);
		INKFResponse resp=context.createResponseFrom(jma);
		resp.setCacheable();
		resp.setCreationCost(16);
		context.setResponse(resp);
	}
	
}
