/******************************************************************************
  (c) Copyright 2002-2005, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: ModelSetOperationsAccessor.java,v $
  Version:       $Name:  $ $Revision: 1.4 $
  Last Modified: $Date: 2005/07/22 15:12:28 $
 *****************************************************************************/

package org.ten60.netkernel.rdf.jena.accessor;

import org.ten60.netkernel.rdf.jena.representation.*;
import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.*;
import com.hp.hpl.jena.rdf.model.*;
import java.util.*;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.util.NetKernelException;

/**
 *An accessor for performing set operations with models
 *
 * @author  pjr
 */
public class ModelSetOperationsAccessor extends NKFAccessorImpl
{
	private static final Map map=new HashMap();
	
	private static final String UNION="jRDFModelUnion";
	private static final int UNION_INT=1;
	private static final String INTERSECTION="jRDFModelIntersection";
	private static final int INTERSECTION_INT=2;
	private static final String DIFFERENCE="jRDFModelDifference";
	private static final int DIFFERENCE_INT=3;
	
	{	map.put(UNION,new Integer(UNION_INT));
		map.put(INTERSECTION, new Integer(INTERSECTION_INT));
		map.put(DIFFERENCE, new Integer(DIFFERENCE_INT));
	}

	/** Creates a new instance of ModelOperationsAccessor */
	public ModelSetOperationsAccessor()
	{	super(2, true, INKFRequestReadOnly.RQT_SOURCE);
	}
	
	public void processRequest(INKFConvenienceHelper context) throws Exception
	{	String key=context.getThisRequest().getActiveType();
		Integer i=(Integer)map.get(key);
		if(i==null)
		{	throw new NetKernelException("Unsupported Active Type", key+" is not supported in the Model Set Operations", null);
		}
		IURAspect result=null;
		IAspectJenaModel jma=(IAspectJenaModel)context.sourceAspect("this:param:model1", IAspectJenaModel.class);
		Model m1=jma.getModelReadOnly();
		if (!m1.supportsSetOperations()) throw new Exception("Set Operations not supported on Model1");
		jma=(IAspectJenaModel)context.sourceAspect("this:param:model2", IAspectJenaModel.class);
		Model m2=jma.getModelReadOnly();
		if (!m2.supportsSetOperations()) throw new Exception("Set Operations not supported on Model2");
		ModelLock ml1=m1.getModelLock();
		ml1.enterCriticalSection(ml1.READ);
		ModelLock ml2=m1.getModelLock();
		ml2.enterCriticalSection(ml1.READ);
		try
		{	switch(i.intValue())
			{	case UNION_INT:
				{	Model union=m1.union(m2);
					result=new JenaModelAspect(union);
				}
				break;
				case INTERSECTION_INT:
				{	Model intersection=m1.intersection(m2);
					result=new JenaModelAspect(intersection);
				}
				break;
				case DIFFERENCE_INT:
				{	Model diff=m1.difference(m2);
					result=new JenaModelAspect(diff);
				}
				break;
			}
		}
		finally
		{	ml1.leaveCriticalSection();
			ml2.leaveCriticalSection();
		}
		INKFResponse resp=context.createResponseFrom(result);
		context.setResponse(resp);
	}
	
}
