/******************************************************************************
  (c) Copyright 2002-2005, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: ModelBooleanOperationsAccessor.java,v $
  Version:       $Name:  $ $Revision: 1.4 $
  Last Modified: $Date: 2005/07/22 15:12:28 $
 *****************************************************************************/

package org.ten60.netkernel.rdf.jena.accessor;

import org.ten60.netkernel.rdf.jena.representation.*;
import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.*;
import com.hp.hpl.jena.rdf.model.*;
import java.util.*;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.aspect.BooleanAspect;
import com.ten60.netkernel.util.NetKernelException;

/**
 *An accessor for performing boolean operations with models
 *
 * @author  pjr
 */
public class ModelBooleanOperationsAccessor extends NKFAccessorImpl
{
	private static final Map map=new HashMap();
	
	private static final String CONTAINS_ALL="jRDFModelContainsAll";
	private static final int CONTAINS_ALL_INT=1;
	private static final String CONTAINS_ANY="jRDFModelContainsAny";
	private static final int CONTAINS_ANY_INT=2;
	private static final String ISOMORPHIC="jRDFModelIsIsomorphic";
	private static final int ISOMORPHIC_INT=3;
	private static final String EMPTY="jRDFModelIsEmpty";
	private static final int EMPTY_INT=4;
	
	{	map.put(CONTAINS_ALL,new Integer(CONTAINS_ALL_INT));
		map.put(CONTAINS_ANY,new Integer(CONTAINS_ANY_INT));
		map.put(ISOMORPHIC,new Integer(ISOMORPHIC_INT));
		map.put(EMPTY,new Integer(EMPTY_INT));
	}

	/** Creates a new instance of ModelOperationsAccessor */
	public ModelBooleanOperationsAccessor()
	{	super(2, true, INKFRequestReadOnly.RQT_SOURCE);
	}
	
	public void processRequest(INKFConvenienceHelper context) throws Exception
	{	String key=context.getThisRequest().getActiveType();
		Integer i=(Integer)map.get(key);
		if(i==null)
		{	throw new NetKernelException("Unsupported Active Type", key+" is not supported in the Boolean Model Operations", null);
		}
		IURAspect result=null;
		if(i.intValue()!=EMPTY_INT)
		{	IAspectJenaModel jma=(IAspectJenaModel)context.sourceAspect("this:param:model1", IAspectJenaModel.class);
			Model m1=jma.getModelReadOnly();
			if (!m1.supportsSetOperations()) throw new Exception("Set Operations not supported on Model1");
			jma=(IAspectJenaModel)context.sourceAspect("this:param:model2", IAspectJenaModel.class);
			Model m2=jma.getModelReadOnly();
			if (!m2.supportsSetOperations()) throw new Exception("Set Operations not supported on Model2");
			ModelLock ml1=m1.getModelLock();
			ml1.enterCriticalSection(ml1.READ);
			ModelLock ml2=m1.getModelLock();
			ml2.enterCriticalSection(ml1.READ);
			try
			{	switch(i.intValue())
				{	case CONTAINS_ALL_INT:
					{	result=new BooleanAspect(m1.containsAll(m2));
					}
					break;
					case CONTAINS_ANY_INT:
					{	result=new BooleanAspect(m1.containsAny(m2));
					}
					break;
					case ISOMORPHIC_INT:
					{	result=new BooleanAspect(m1.isIsomorphicWith(m2));
					}
				}
			}
			finally
			{	ml1.leaveCriticalSection();
				ml2.leaveCriticalSection();
			}
		}
		else
		{	IAspectJenaModel jma=(IAspectJenaModel)context.sourceAspect("this:param:operand", IAspectJenaModel.class);
			Model m=jma.getModelReadOnly();
			ModelLock ml=m.getModelLock();
			ml.enterCriticalSection(ml.READ);
			try
			{	result=new BooleanAspect(m.isEmpty());
			}
			finally
			{	ml.leaveCriticalSection();				
			}
		}
		INKFResponse resp=context.createResponseFrom(result);
		context.setResponse(resp);
	}
	
}
