/*
	PiNKY Project : Execute Yahoo Pipelines on 1060 NetKernel!
    Copyright (C) 2007  Peter Rodgers

	GPL License Notice:
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
	
	1060 Public License Notice:
	 * This Software is licensed to You, the licensee, for use under the terms of
	 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
	 * License v1.0 [www.1060research.com/license] before using or redistributing
	 * this software.
	 *
	 * In summary the 1060 Public license has the following conditions.
	 * A. You may use the Software free of charge provided you agree to the terms
	 * laid out in the 1060 Public License v1.0
	 * B. You are only permitted to use the Software with components or applications
	 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
	 * for which licensing has been approved by 1060 Research Limited.
	 * You may write your own software for execution by this Software provided any
	 * distribution of your software with this Software complies with terms set out
	 * in section 2 of the 1060 Public License v1.0
	 * C. You may redistribute the Software provided you comply with the terms of
	 * the 1060 Public License v1.0 and that no warranty is implied or given.
	 * D. If you find you are unable to comply with this license you may seek to
	 * obtain an alternative license from 1060 Research Limited by contacting
	 * license@1060research.com or by visiting www.1060research.com
	 *
	 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
	 * LICENSE V1.0 FOR DETAILS
	 *
	 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
	 * THE DISTRIBUTED license.txt OR www.1060research.com/license

*/

package org.pinkypipes.transrept;

import org.pinkypipes.aspect.IAspectFeed;
import org.ten60.netkernel.layer1.nkf.INKFConvenienceHelper;
import org.ten60.netkernel.layer1.nkf.INKFRequestReadOnly;
import org.ten60.netkernel.layer1.nkf.INKFResponse;
import org.ten60.netkernel.layer1.nkf.impl.NKFTransreptorImpl;

import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.WireFeedOutput;
import com.ten60.netkernel.urii.IURAspect;
import com.ten60.netkernel.urii.aspect.IAspectBinaryStream;
import com.ten60.netkernel.urii.aspect.StringAspect;

/**
 * Transreptor to go from IAspectFeed.
 * @author  pjr
 */
public class FeedAspectToXXXTransreptor extends NKFTransreptorImpl
{	
	public boolean supports(com.ten60.netkernel.urii.IURRepresentation aFrom, Class aTo)
	{	return aFrom.hasAspect(IAspectFeed.class);
	}	
	
	/**
	 *Transrept - can be made more efficient by testing required aspect.
	 */
	protected void transrepresent(INKFConvenienceHelper context) throws Exception
	{	IAspectFeed fa=(IAspectFeed)context.sourceAspect(INKFRequestReadOnly.URI_SYSTEM, IAspectFeed.class);
		SyndFeed f=fa.getFeedExpertsOnly();
		Class to=context.getThisRequest().getAspectClass();
		WireFeedOutput wfo=new WireFeedOutput();
		String s=wfo.outputString(f.createWireFeed());
		IURAspect result=new StringAspect(s);
		if(!to.equals(IAspectBinaryStream.class))
		{	result=context.transrept(result, to);		//Make this more efficient later by testing for specific target aspects.
		}
		INKFResponse resp=context.createResponseFrom(result);
		resp.setMimeType("text/xml");
	}	
}
