/*
	PiNKY Project : Execute Yahoo Pipelines on 1060 NetKernel!
    Copyright (C) 2007  Peter Rodgers

	GPL License Notice:
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
	
	1060 Public License Notice:
	 * This Software is licensed to You, the licensee, for use under the terms of
	 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
	 * License v1.0 [www.1060research.com/license] before using or redistributing
	 * this software.
	 *
	 * In summary the 1060 Public license has the following conditions.
	 * A. You may use the Software free of charge provided you agree to the terms
	 * laid out in the 1060 Public License v1.0
	 * B. You are only permitted to use the Software with components or applications
	 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
	 * for which licensing has been approved by 1060 Research Limited.
	 * You may write your own software for execution by this Software provided any
	 * distribution of your software with this Software complies with terms set out
	 * in section 2 of the 1060 Public License v1.0
	 * C. You may redistribute the Software provided you comply with the terms of
	 * the 1060 Public License v1.0 and that no warranty is implied or given.
	 * D. If you find you are unable to comply with this license you may seek to
	 * obtain an alternative license from 1060 Research Limited by contacting
	 * license@1060research.com or by visiting www.1060research.com
	 *
	 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
	 * LICENSE V1.0 FOR DETAILS
	 *
	 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
	 * THE DISTRIBUTED license.txt OR www.1060research.com/license

 
Created on 13 February 2007, 11:31
*/

package org.pinkypipes.accessor;

import org.pinkypipes.aspect.FeedAspect;
import org.pinkypipes.aspect.IAspectFeed;
import org.ten60.netkernel.layer1.nkf.INKFConvenienceHelper;
import org.ten60.netkernel.layer1.nkf.INKFRequestReadOnly;
import org.ten60.netkernel.layer1.nkf.impl.NKFAccessorImpl;

import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.xda.*;
import java.util.*;
import com.ten60.netkernel.util.NetKernelException;

import com.sun.syndication.feed.synd.*;


/**
 * SetFeedInfoAccessor - Sets the primary metadata of a feed.
 * 
 * @author  pjr
 */
public class SetFeedInfoAccessor extends NKFAccessorImpl
{
	
	/** Creates a new instance of SetFeedInfoAccessor */
	public SetFeedInfoAccessor()
	{	super(SAFE_FOR_CONCURRENT_USE, INKFRequestReadOnly.RQT_SOURCE);
	}
	
	/**
	 Info XML format example...
	 
	 <info>
		<author>Peter Rodgers</author>
		<author>Team PiNKY</author>		<!--Second author is ignored by RSS feeds-->
		<contributor>ABC</contributor>	<!--Contributor is ignored by RSS feeds-->
		<contributor>DEF</contributor>
		<description>Test</description>
		<title>Test Feed</title>
		<uri>urn:org:pinkypipes:pinky:test:feed:1</uri>
		<language>en-test</language>
		<copyright>(C) PinkyPipes</copyright>
		<link>http://pinkypipes.org</link>
		<link>http://1060.org/blogxter/</link>  <!--Second Link is ignored by RSS feeds-->
		<image>
			<title>Test Feed Image</title>
			<link>http://pinkypipes.org/</link>
			<url>http://pinkypipes.org/pinky-icon-128.png</url>
			<description>Pinky Feed Logo</description>
		</image>
		<category>
			<name>Test</name>
			<taxonomyuri>urn:org:pinkypipes:test</taxonomyuri>
		</category>
		<category>
			<name>Pinky</name>
			<taxonomyuri>urn:org:pinkypipes</taxonomyuri>
		</category>
		<date>now</date>  <!--Sets feed published date to now-->
	</info>
	*/
	
	
	/**
	 *
	 */
	public void processRequest(INKFConvenienceHelper context) throws Exception
	{	IAspectFeed fa=(IAspectFeed)context.sourceAspect("this:param:feed", IAspectFeed.class);
		IXAspect xa=(IXAspect)context.sourceAspect("this:param:operator", IXAspect.class);
		
		SyndFeed f=fa.getFeed();
		IXDAReadOnly x=xa.getXDA();
		IXDAReadOnlyIterator it=x.readOnlyIterator("/info/author");
		if(it.hasNext())
		{	List l=new ArrayList(4);
			while(it.hasNext())
			{	it.next();
				SyndPerson p=new SyndPersonImpl();
				p.setName(it.getText(".", true));
				l.add(p);
			}
			f.setAuthors(l);
		}
		it=x.readOnlyIterator("/info/category");
		if(it.hasNext())
		{	List l=new ArrayList(4);
			while(it.hasNext())
			{	it.next();
				SyndCategory c=new SyndCategoryImpl();
				c.setName(it.getText("name", true));
				c.setTaxonomyUri(it.getText("taxonomyuri", true));
				l.add(c);
			}
			f.setCategories(l);
		}
		it=x.readOnlyIterator("/info/contributor");
		if(it.hasNext())
		{	List l=new ArrayList(4);
			while(it.hasNext())
			{	it.next();
				SyndPerson p=new SyndPersonImpl();
				p.setName(it.getText(".", true));
				l.add(p);
			}
			f.setContributors(l);
		}
		it=x.readOnlyIterator("/info/link");
		if(it.hasNext())
		{	f.setLink(x.getText("/info/link[1]",true));   //Workaround possible bug in rome - the setLinks() method doesn't seem to work on RSS link
			List l=new ArrayList(4);
			while(it.hasNext())
			{	it.next();
				SyndLink lk=new SyndLinkImpl();
				lk.setHref(it.getText(".", true));
				l.add(lk);
			}
			f.setLinks(l);
		}
		if(x.isTrue("/info/title"))
		{	f.setTitle(x.getText("/info/title", true));
		}
		if(x.isTrue("/info/description"))
		{	f.setDescription(x.getText("/info/description", true));
		}
		if(x.isTrue("/info/language"))
		{	f.setLanguage(x.getText("/info/language", true));
		}
		if(x.isTrue("/info/copyright"))
		{	f.setCopyright(x.getText("/info/copyright", true));
		}
		if(x.isTrue("/info/uri"))
		{	f.setUri(x.getText("/info/uri", true));
		}
		if(x.isTrue("/info/date"))
		{	String d=x.getText("/info/date",true).toUpperCase();
			if(d.equals("NOW"))
			{	f.setPublishedDate(new Date());
			}
			else
			{	throw new NetKernelException("Date parsing not yet implemented - any volunteers?");
			}
		}
		if(x.isTrue("/info/image"))
		{	SyndImage i=new SyndImageImpl();
			if(x.isTrue("/info/image/description"))
			{	i.setDescription(x.getText("/info/image/description", true));
			}
			if(x.isTrue("/info/image/title"))
			{	i.setTitle(x.getText("/info/image/title", true));
			}
			if(x.isTrue("/info/image/link"))
			{	i.setLink(x.getText("/info/image/link", true));
			}
			if(x.isTrue("/info/image/url"))
			{	i.setUrl(x.getText("/info/image/url", true));
			}
			f.setImage(i);
		}
		context.createResponseFrom(new FeedAspect(f));
	}
	
}
