/*
 * LDAPConnectionPoolTransreptor.java
 *
 * Created on 10 August 2005, 21:44
 */

package org.ten60.netkernel.ldap.transreptor;

import org.ten60.netkernel.layer1.nkf.impl.*;
import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.ldap.aspect.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.ldap.aspect.LDAPConnectionPoolAspect;


/**
 *
 * @author  pjr
 */
public class LDAPConnectionPoolTransreptor extends NKFTransreptorImpl
{	
	/** Creates a new instance of LDAPConnectionPoolTransreptor */
	public LDAPConnectionPoolTransreptor()
	{
	}
	
	public boolean supports(com.ten60.netkernel.urii.IURRepresentation aFrom, Class aTo)
	{	return aTo.isAssignableFrom(LDAPConnectionPoolAspect.class);
	}
	
	protected void transrepresent(INKFConvenienceHelper context) throws Exception
	{	IXAspect xa=(IXAspect)context.sourceAspect(INKFRequestReadOnly.URI_SYSTEM, IXAspect.class);
		IXDAReadOnly xda=xa.getXDA();
		String host=xda.getText("/LDAPConnectionConfig/host", true);
		int port=Integer.parseInt(xda.getText("/LDAPConnectionConfig/port",true));
		int poolsize=Integer.parseInt(xda.getText("/LDAPConnectionConfig/connectionPoolSize",true));
		int sharesize=Integer.parseInt(xda.getText("/LDAPConnectionConfig/sharedConnectionSize",true));
		boolean ssl=xda.isTrue("/LDAPConnectionConfig/ssl");
		LDAPConnectionPoolAspect cpa=new LDAPConnectionPoolAspect(host, port, poolsize, sharesize, ssl);
		
		context.createResponseFrom(cpa);
	}
	
}
