/*
 * JSONFromXML.java
 *
 * Created on 19 June 2006, 11:25
 */

package org.ten60.json.accessor;

import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.*;
import org.ten60.json.representation.*;
import org.json.*;
import com.ten60.netkernel.urii.aspect.*;
import java.io.*;
/**
 *
 * @author  pjr
 */
public class JSONFromXML extends NKFAccessorImpl
{
	
	/** Creates a new instance of JSONFromXML */
	public JSONFromXML()
	{	super(false, INKFRequestReadOnly.RQT_SOURCE);
	}
	
	public void processRequest(INKFConvenienceHelper context) throws Exception
	{	IAspectBinaryStream bsa=(IAspectBinaryStream)context.sourceAspect("this:param:operand", IAspectBinaryStream.class);
		ByteArrayOutputStream baos=new ByteArrayOutputStream(1024);
		bsa.write(baos);
		JSONObject jo=XML.toJSONObject(baos.toString());
		JSONAspect joa=new JSONAspect(jo);
		context.createResponseFrom(joa);
	}
	
}
