/*
 * IJSONObjectReadOnly.java
 *
 * Created on 16 June 2006, 09:55
 */

package org.json;

import java.util.*;
import java.io.*;

/**
 * Immutable Read-only interface for JSONObject
 * @author  pjr
 */
public interface IJSONObjectReadOnly
{	public Object get(String key) throws JSONException;	
	public boolean getBoolean(String key) throws JSONException;
	public double getDouble(String key) throws JSONException;
	public int getInt(String key) throws JSONException;
	public JSONArray getJSONArray(String key) throws JSONException;
	public JSONObject getJSONObject(String key) throws JSONException;
	public long getLong(String key) throws JSONException;
	public String getString(String key) throws JSONException;
	public boolean has(String key);
	public boolean isNull(String key);
	public Iterator keys();
	public int length();
	public JSONArray names();
	public Object opt(String key);
	public boolean optBoolean(String key);
	public boolean optBoolean(String key, boolean defaultValue);
	public double optDouble(String key);
	public double optDouble(String key, double defaultValue);
	public int optInt(String key);
	public int optInt(String key, int defaultValue);
	public JSONObject optJSONObject(String key);
	public long optLong(String key);
	public long optLong(String key, long defaultValue);
	public String optString(String key);
	public String optString(String key, String defaultValue);
	public String toString();
	public String toString(int indentFactor) throws JSONException;
	public Writer write(Writer writer) throws JSONException;
	
}
