/*
 * PHPScriptCompiler.java
 *
 * Created on October 11, 2007, 2:33 PM
 */

package org.ten60.netkernel.php.transreptor;

import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.*;
import org.ten60.netkernel.php.representation.CompiledPHPScriptAspect;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.aspect.*;
import com.caucho.quercus.script.*;
import javax.script.*;

import org.ten60.netkernel.layer1.util.SuperStackClassLoader;

/**
 *
 * @author  pjr
 */
public class PHPScriptCompiler extends NKFTransreptorImpl
{
	public boolean supports(IURRepresentation aFrom, Class aTo)
	{	return aTo.isAssignableFrom(CompiledPHPScriptAspect.class);
	}
	
	protected void transrepresent(INKFConvenienceHelper context) throws Exception
	{	Thread.currentThread().setContextClassLoader(new SuperStackClassLoader(context.getKernelHelper().getThisKernelRequest()));
		IAspectString sa=(IAspectString)context.sourceAspect(INKFRequestReadOnly.URI_SYSTEM, IAspectString.class);
		QuercusScriptEngineFactory qsef=new QuercusScriptEngineFactory();
		QuercusScriptEngine se=(QuercusScriptEngine)qsef.getScriptEngine();
		context.createResponseFrom(new CompiledPHPScriptAspect(se.compile(sa.getString())));
	}
	
}
